/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.ResourceAggregator;
import com.supermartijn642.core.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.ApiStatus;

public abstract class ResourceCache {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public abstract boolean doesResourceExist(ResourceType var1, String var2, String var3, String var4, String var5);

    public abstract void trackToBeGeneratedResource(ResourceType var1, String var2, String var3, String var4, String var5);

    public abstract void saveResource(ResourceType var1, byte[] var2, String var3, String var4, String var5, String var6);

    public abstract <T> void saveResource(ResourceType var1, ResourceAggregator<?, T> var2, T var3, String var4, String var5, String var6, String var7);

    public void saveJsonResource(ResourceType resourceType, JsonObject json, String namespace, String directory, String fileName) {
        byte[] bytes = GSON.toJson((JsonElement)json).getBytes(StandardCharsets.UTF_8);
        this.saveResource(resourceType, bytes, namespace, directory, fileName, fileName.endsWith(".json") ? "" : ".json");
    }

    public abstract Optional<InputStream> getExistingResource(ResourceType var1, String var2, String var3, String var4, String var5);

    @ApiStatus.Internal
    public static ResourceCache wrap(ExistingFileHelper existingFileHelper, HashCache hashCache, Path outputDirectory) {
        return new HashCacheWrapper(existingFileHelper, hashCache, outputDirectory);
    }

    @ApiStatus.Internal
    public static class HashCacheWrapper
    extends ResourceCache {
        private final Map<Path, HashCode> presentFiles = new HashMap<Path, HashCode>();
        private final Map<Path, HashCode> writtenFiles = new HashMap<Path, HashCode>();
        private final Map<Path, Pair<ResourceAggregator<Object, Object>, Object>> aggregatedResources = new HashMap<Path, Pair<ResourceAggregator<Object, Object>, Object>>();
        private final Set<Path> toBeGenerated = new HashSet<Path>();
        private final ExistingFileHelper existingFileHelper;
        private final Path outputDirectory;
        private final HashCache cache;
        private boolean allowWrites = true;
        private int writes = 0;

        private HashCacheWrapper(ExistingFileHelper existingFileHelper, HashCache cache, Path outputFolder) {
            if (outputFolder == null) {
                throw new IllegalArgumentException("Output directory must not be null!");
            }
            this.outputDirectory = outputFolder;
            this.existingFileHelper = existingFileHelper;
            this.cache = cache;
        }

        public void readHashCache() {
            Path cachePath = this.cache.getProviderCachePath("Core Lib Generators");
            this.cache.cachePaths.add(cachePath);
            HashCache.ProviderCache providerCache = HashCache.readCache((Path)this.outputDirectory, (Path)cachePath);
            this.cache.caches.put("Core Lib Generators", providerCache);
            this.cache.initialCount += providerCache.count();
            this.cache.caches.values().stream().flatMap(cache -> cache.data().entrySet().stream()).forEach(entry -> this.presentFiles.put(this.outputDirectory.relativize((Path)entry.getKey()), (HashCode)entry.getValue()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean existsInGeneratedFiles(Path path) {
            if (this.toBeGenerated.contains(path)) return true;
            if (this.aggregatedResources.containsKey(path)) return true;
            if (this.writtenFiles.containsKey(path)) return true;
            if (!this.cache.caches.entrySet().stream().filter(entry -> this.cache.cachesToWrite.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(cache -> cache.data().entrySet().stream()).map(Map.Entry::getKey).anyMatch(this.outputDirectory.resolve(path)::equals)) return false;
            return true;
        }

        private boolean existsInLoadedResources(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(directory + "/" + fileName + extension));
            return this.existingFileHelper.exists(location, resourceType == ResourceType.DATA ? PackType.SERVER_DATA : PackType.CLIENT_RESOURCES);
        }

        private Path constructPath(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            return Paths.get(resourceType.getDirectoryName(), namespace, directory, fileName + extension);
        }

        @Override
        public boolean doesResourceExist(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            Path path = this.constructPath(resourceType, namespace, directory, fileName, extension);
            return this.existsInGeneratedFiles(path) || this.existsInLoadedResources(resourceType, namespace, directory, fileName, extension);
        }

        @Override
        public void trackToBeGeneratedResource(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            this.toBeGenerated.add(this.constructPath(resourceType, namespace, directory, fileName, extension));
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(directory + "/" + fileName + extension));
            this.existingFileHelper.trackGenerated(location, resourceType == ResourceType.DATA ? PackType.SERVER_DATA : PackType.CLIENT_RESOURCES, extension, directory);
        }

        @Override
        public Optional<InputStream> getExistingResource(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            try {
                Resource resource = this.existingFileHelper.getResource(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(directory + "/" + fileName + extension)), resourceType == ResourceType.DATA ? PackType.SERVER_DATA : PackType.CLIENT_RESOURCES);
                return Optional.of(resource.open());
            }
            catch (FileNotFoundException | NoSuchElementException e) {
                return Optional.empty();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void saveResource(ResourceType resourceType, byte[] data, String namespace, String directory, String fileName, String extension) {
            Path fullPath;
            Path path;
            block15: {
                block14: {
                    if (!this.allowWrites) {
                        throw new RuntimeException("Resources cannot be saved during this stage!");
                    }
                    path = this.constructPath(resourceType, namespace, directory, fileName, extension);
                    fullPath = this.outputDirectory.resolve(path);
                    if (this.writtenFiles.containsKey(path) || this.aggregatedResources.containsKey(path)) break block14;
                    if (!this.cache.caches.entrySet().stream().filter(entry -> this.cache.cachesToWrite.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(cache -> cache.data().entrySet().stream()).map(Map.Entry::getKey).anyMatch(fullPath::equals)) break block15;
                }
                throw new RuntimeException("Duplicate file '" + String.valueOf(path) + "'!");
            }
            HashCode hashCode = Hashing.sha1().hashBytes(data);
            if (this.presentFiles.containsKey(path) && this.presentFiles.get(path).equals((Object)hashCode) && fullPath.toFile().exists()) {
                this.writtenFiles.put(path, hashCode);
                this.toBeGenerated.remove(path);
                return;
            }
            fullPath.toFile().getParentFile().mkdirs();
            try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                outputStream.write(data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.writtenFiles.put(path, hashCode);
            this.toBeGenerated.remove(path);
            ++this.writes;
        }

        @Override
        public <T> void saveResource(ResourceType resourceType, ResourceAggregator<?, T> aggregator, T data, String namespace, String directory, String fileName, String extension) {
            Path path;
            block8: {
                block7: {
                    if (!this.allowWrites) {
                        throw new RuntimeException("Resources cannot be saved during this stage!");
                    }
                    path = this.constructPath(resourceType, namespace, directory, fileName, extension);
                    Path fullPath = this.outputDirectory.resolve(path);
                    if (this.writtenFiles.containsKey(path)) break block7;
                    if (!this.cache.caches.entrySet().stream().filter(entry -> this.cache.cachesToWrite.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(cache -> cache.data().entrySet().stream()).map(Map.Entry::getKey).anyMatch(fullPath::equals)) break block8;
                }
                throw new RuntimeException("Duplicate file '" + String.valueOf(path) + "'!");
            }
            Pair<ResourceAggregator<Object, Object>, Object> oldEntry = this.aggregatedResources.get(path);
            if (oldEntry != null && oldEntry.left() != aggregator) {
                throw new RuntimeException("Incompatible aggregators for file '" + String.valueOf(path) + "': '" + String.valueOf(oldEntry.left().getClass()) + "' and '" + String.valueOf(aggregator.getClass()) + "'!");
            }
            Object oldData = oldEntry == null ? aggregator.initialData() : oldEntry.right();
            try {
                oldData = aggregator.combine(oldData, data);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to combine data for file '" + String.valueOf(path) + "'!", e);
            }
            this.aggregatedResources.put(path, Pair.of(aggregator, oldData));
        }

        public void allowWrites(boolean allow) {
            this.allowWrites = allow;
        }

        public void finish() {
            this.aggregatedResources.forEach((path, pair) -> {
                byte[] bytes;
                ResourceAggregator aggregator = (ResourceAggregator)pair.left();
                Object data = pair.right();
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                    aggregator.write(stream, data);
                    bytes = stream.toByteArray();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Path fullPath = this.outputDirectory.resolve((Path)path);
                HashCode hashCode = Hashing.sha1().hashBytes(bytes);
                if (this.presentFiles.containsKey(path) && this.presentFiles.get(path).equals((Object)hashCode) && fullPath.toFile().exists()) {
                    this.writtenFiles.put((Path)path, hashCode);
                    this.toBeGenerated.remove(path);
                    return;
                }
                fullPath.toFile().getParentFile().mkdirs();
                try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                    outputStream.write(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.writtenFiles.put((Path)path, hashCode);
                this.toBeGenerated.remove(path);
                ++this.writes;
            });
            ImmutableMap.Builder builder = ImmutableMap.builder();
            this.writtenFiles.forEach((path, hashCode) -> builder.put((Object)this.outputDirectory.resolve((Path)path), hashCode));
            HashCache.ProviderCache cache = new HashCache.ProviderCache(this.cache.versionId, builder.build());
            this.cache.applyUpdate(new HashCache.UpdateResult("Core Lib Generators", cache, this.writes));
            this.cache.cachePaths.add(this.cache.getProviderCachePath("Core Lib Generators"));
            if (!this.toBeGenerated.isEmpty()) {
                throw new RuntimeException("Some tracked files did not get written: " + this.toBeGenerated.stream().map(Path::toString).map(s -> "'" + s + "'").collect(Collectors.joining(",")));
            }
        }
    }
}

