/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.item.EditableClientItemExtensions;
import com.supermartijn642.core.item.ItemProperties;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class BaseBlockItem
extends BlockItem {
    private final ItemProperties properties;

    public BaseBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
        this.properties = null;
    }

    public BaseBlockItem(Block block, ItemProperties properties) {
        super(block, properties.toUnderlying());
        this.properties = properties;
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
    }

    public ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        return ItemUseResult.fromUnderlying((InteractionResultHolder<ItemStack>)super.use(level, player, hand));
    }

    public InteractionFeedback interactWithBlockFirst(ItemStack stack, Player player, InteractionHand hand, Level level, BlockPos hitPos, Direction hitSide, Vec3 hitLocation) {
        return InteractionFeedback.PASS;
    }

    public InteractionFeedback interactWithBlock(ItemStack stack, Player player, InteractionHand hand, Level level, BlockPos hitPos, Direction hitSide, Vec3 hitLocation) {
        return InteractionFeedback.fromUnderlying(super.useOn(new UseOnContext(level, player, hand, stack, new BlockHitResult(hitLocation, hitSide, hitPos, false))));
    }

    public InteractionFeedback interactWithEntity(ItemStack stack, LivingEntity target, Player player, InteractionHand hand) {
        return InteractionFeedback.PASS;
    }

    public void inventoryUpdate(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> information, TooltipFlag flag) {
        this.appendItemInformation(stack, information::add, flag.isAdvanced());
        super.appendHoverText(stack, context, information, flag);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return this.interact(player.getItemInHand(hand), player, hand, level).toUnderlying(level.isClientSide);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return this.interactWithEntity((ItemStack)stack, (LivingEntity)target, (Player)player, (InteractionHand)hand).interactionResult;
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.interactWithBlock((ItemStack)context.getItemInHand(), (Player)context.getPlayer(), (InteractionHand)context.getHand(), (Level)context.getLevel(), (BlockPos)context.getClickedPos(), (Direction)context.getClickedFace(), (Vec3)context.getClickLocation()).interactionResult;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return this.interactWithBlockFirst((ItemStack)stack, (Player)context.getPlayer(), (InteractionHand)context.getHand(), (Level)context.getLevel(), (BlockPos)context.getClickedPos(), (Direction)context.getClickedFace(), (Vec3)context.getClickLocation()).interactionResult;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        this.inventoryUpdate(stack, level, entity, slot, isSelected);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new EditableClientItemExtensions());
    }

    public boolean isInCreativeGroup(CreativeModeTab tab) {
        return this.properties != null && (this.properties.groups.contains(tab) || !this.properties.groups.isEmpty() && tab == CreativeItemGroup.getSearch());
    }

    public static class ItemUseResult {
        private final InteractionResult result;
        private final ItemStack resultingStack;

        public static ItemUseResult pass(ItemStack stack) {
            return new ItemUseResult(InteractionResult.SUCCESS, stack);
        }

        public static ItemUseResult consume(ItemStack stack) {
            return new ItemUseResult(InteractionResult.CONSUME, stack);
        }

        public static ItemUseResult success(ItemStack stack) {
            return new ItemUseResult(InteractionResult.SUCCESS, stack);
        }

        public static ItemUseResult fail(ItemStack stack) {
            return new ItemUseResult(InteractionResult.FAIL, stack);
        }

        @Deprecated
        public static ItemUseResult fromUnderlying(InteractionResultHolder<ItemStack> underlying) {
            return new ItemUseResult(underlying.getResult(), (ItemStack)underlying.getObject());
        }

        private ItemUseResult(InteractionResult result, ItemStack resultingStack) {
            this.result = result;
            this.resultingStack = resultingStack;
        }

        @Deprecated
        public InteractionResultHolder<ItemStack> toUnderlying(boolean isClientSide) {
            return new InteractionResultHolder(this.result == InteractionResult.SUCCESS ? (isClientSide ? InteractionResult.SUCCESS : InteractionResult.CONSUME) : this.result, (Object)this.resultingStack);
        }
    }

    public static enum InteractionFeedback {
        PASS(InteractionResult.PASS),
        CONSUME(InteractionResult.CONSUME),
        SUCCESS(InteractionResult.SUCCESS);

        private final InteractionResult interactionResult;

        private InteractionFeedback(InteractionResult interactionResult) {
            this.interactionResult = interactionResult;
        }

        @Deprecated
        public static InteractionFeedback fromUnderlying(InteractionResult interactionResult) {
            switch (interactionResult) {
                case SUCCESS: {
                    return SUCCESS;
                }
                case CONSUME: 
                case CONSUME_PARTIAL: 
                case FAIL: {
                    return CONSUME;
                }
                case PASS: {
                    return PASS;
                }
            }
            return null;
        }
    }
}

