/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    @Final
    @Shadow(remap=false)
    private ICondition.IContext context;
    @Final
    @Shadow
    private HolderLookup.Provider registries;

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void apply(Map<ResourceLocation, JsonElement> recipes, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        HashSet<ResourceLocation> removed = null;
        for (Map.Entry<ResourceLocation, JsonElement> entry : recipes.entrySet()) {
            String type;
            if (entry.getValue() == null || !entry.getValue().isJsonObject()) continue;
            ResourceLocation identifier = entry.getKey();
            JsonObject json = entry.getValue().getAsJsonObject();
            if (json == null || !json.has("type") || !json.get("type").isJsonPrimitive() || !json.getAsJsonPrimitive("type").isString() || !RegistryUtil.isValidIdentifier(type = json.get("type").getAsString()) || !ResourceLocation.parse((String)type).equals((Object)Registries.RECIPE_SERIALIZERS.getIdentifier(ConditionalRecipeSerializer.INSTANCE))) continue;
            JsonElement recipeJson = ConditionalRecipeSerializer.unwrapRecipe(identifier, json, this.registries, this.context);
            if (recipeJson == null) {
                if (removed == null) {
                    removed = new HashSet<ResourceLocation>();
                }
                removed.add(identifier);
                continue;
            }
            recipes.put(identifier, recipeJson);
        }
        if (removed != null) {
            removed.forEach(recipes::remove);
        }
    }

    @Inject(method={"fromJson(Lnet/minecraft/resources/ResourceLocation;Lcom/google/gson/JsonObject;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/crafting/RecipeHolder;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fromJson(ResourceLocation recipeLocation, JsonObject json, HolderLookup.Provider provider, CallbackInfoReturnable<RecipeHolder<?>> ci) {
        String type;
        if (json != null && json.has("type") && json.get("type").isJsonPrimitive() && json.getAsJsonPrimitive("type").isString() && RegistryUtil.isValidIdentifier(type = json.get("type").getAsString()) && ResourceLocation.parse((String)type).equals((Object)Registries.RECIPE_SERIALIZERS.getIdentifier(ConditionalRecipeSerializer.INSTANCE))) {
            JsonElement recipeJson = ConditionalRecipeSerializer.unwrapRecipe(recipeLocation, json, provider, ICondition.IContext.EMPTY);
            if (recipeJson == null) {
                ci.setReturnValue((Object)new RecipeHolder(recipeLocation, ConditionalRecipeSerializer.DUMMY_RECIPE));
            } else {
                ci.setReturnValue((Object)RecipeManager.fromJson((ResourceLocation)recipeLocation, (JsonObject)json.getAsJsonObject("recipe"), (HolderLookup.Provider)provider));
            }
        }
    }
}

