/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.core.registry.RegistryUtil;
import io.netty.util.collection.IntObjectHashMap;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

public class PacketChannel {
    private final String modid;
    private final String name;
    private final SimpleChannel channel;
    private int index = 0;
    private final HashMap<Class<? extends BasePacket>, Integer> packet_to_index = new HashMap();
    private final IntObjectHashMap<Supplier<? extends BasePacket>> index_to_packet = new IntObjectHashMap();
    private final HashMap<Class<? extends BasePacket>, Boolean> packet_to_queued = new HashMap();

    public static PacketChannel create(String modid, String channelName) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(channelName)) {
            throw new IllegalArgumentException("Channel name '" + channelName + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName() + "' is creating a packet channel for different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is creating a packet channel for modid '" + modid + "'!");
        }
        return new PacketChannel(modid, channelName);
    }

    public static PacketChannel create(String modid) {
        return PacketChannel.create(modid, "main");
    }

    @Deprecated
    public static PacketChannel create() {
        return PacketChannel.create(ModLoadingContext.get().getActiveNamespace(), "main");
    }

    private PacketChannel(String modid, String name) {
        this.modid = modid;
        this.name = name;
        this.channel = ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name)).networkProtocolVersion(1).acceptedVersions((status, version) -> version == 1).simpleChannel();
        this.channel.messageBuilder(InternalPacket.class, 0).encoder((message, buffer) -> InternalPacket.write(this, message, buffer)).decoder(buffer -> InternalPacket.read(this, buffer)).consumerNetworkThread((message, context) -> InternalPacket.handle(this, message, context)).add();
    }

    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, boolean shouldBeQueued) {
        if (this.packet_to_index.containsKey(packetClass)) {
            throw new IllegalArgumentException("Class '" + String.valueOf(packetClass) + "' has already been registered!");
        }
        int index = this.index++;
        this.packet_to_index.put(packetClass, index);
        this.index_to_packet.put(index, packetSupplier);
        this.packet_to_queued.put(packetClass, shouldBeQueued);
    }

    public void sendToServer(BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.send((Object)new InternalPacket().setPacket(packet), PacketDistributor.SERVER.noArg());
    }

    public void sendToPlayer(Player player, BasePacket packet) {
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet);
        this.channel.send((Object)new InternalPacket().setPacket(packet), PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)));
    }

    public void sendToAllPlayers(BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.send((Object)new InternalPacket().setPacket(packet), PacketDistributor.ALL.noArg());
    }

    public void sendToDimension(ResourceKey<Level> dimension, BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.send((Object)new InternalPacket().setPacket(packet), PacketDistributor.DIMENSION.with(dimension));
    }

    public void sendToDimension(Level world, BasePacket packet) {
        if (world.isClientSide) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToDimension((ResourceKey<Level>)world.dimension(), packet);
    }

    public void sendToAllTrackingEntity(Entity entity, BasePacket packet) {
        if (entity.level().isClientSide) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet);
        this.channel.send((Object)new InternalPacket().setPacket(packet), PacketDistributor.TRACKING_ENTITY.with((Object)entity));
    }

    public void sendToAllNear(ResourceKey<Level> world, double x, double y, double z, double radius, BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.send((Object)new InternalPacket().setPacket(packet), PacketDistributor.NEAR.with((Object)new PacketDistributor.TargetPoint(x, y, z, radius, world)));
    }

    public void sendToAllNear(ResourceKey<Level> world, BlockPos pos, double radius, BasePacket packet) {
        this.sendToAllNear(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, radius, packet);
    }

    public void sendToAllNear(Level world, double x, double y, double z, double radius, BasePacket packet) {
        if (world.isClientSide) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear((ResourceKey<Level>)world.dimension(), x, y, z, radius, packet);
    }

    public void sendToAllNear(Level world, BlockPos pos, double radius, BasePacket packet) {
        if (world.isClientSide) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear((ResourceKey<Level>)world.dimension(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, radius, packet);
    }

    private void checkRegistration(BasePacket packet) {
        if (!this.packet_to_index.containsKey(packet.getClass())) {
            throw new IllegalArgumentException("Tried to send unregistered packet '" + String.valueOf(packet.getClass()) + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
    }

    private void write(BasePacket packet, FriendlyByteBuf buffer) {
        int index = this.packet_to_index.get(packet.getClass());
        buffer.writeInt(index);
        packet.write(buffer);
    }

    private BasePacket read(FriendlyByteBuf buffer) {
        int index = buffer.readInt();
        if (!this.index_to_packet.containsKey(index)) {
            throw new RuntimeException("Received an unregistered packet with index '" + index + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
        BasePacket packet = (BasePacket)((Supplier)this.index_to_packet.get(index)).get();
        packet.read(buffer);
        return packet;
    }

    private void handle(BasePacket packet, CustomPayloadEvent.Context contextSupplier) {
        contextSupplier.setPacketHandled(true);
        PacketContext context = new PacketContext(contextSupplier);
        if (packet.verify(context)) {
            if (this.packet_to_queued.get(packet.getClass()).booleanValue()) {
                context.queueTask(() -> packet.handle(context));
            } else {
                packet.handle(context);
            }
        }
    }

    private static class InternalPacket {
        private BasePacket packet;

        private InternalPacket() {
        }

        public static InternalPacket read(PacketChannel channel, FriendlyByteBuf buffer) {
            return new InternalPacket().setPacket(channel.read(buffer));
        }

        public static void write(PacketChannel channel, InternalPacket packet, FriendlyByteBuf buffer) {
            channel.write(packet.packet, buffer);
        }

        public static void handle(PacketChannel channel, InternalPacket packet, CustomPayloadEvent.Context context) {
            channel.handle(packet.packet, context);
        }

        public InternalPacket setPacket(BasePacket packet) {
            this.packet = packet;
            return this;
        }
    }
}

