/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetTextHolderPacket;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FramedBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;

public class SignPostGui
extends Screen {
    private TextFieldHelper textInputUtil;
    private int editLine;
    private int updateCounter;
    private final SignPostBlockTile tile;
    private static final int MAXLINES = 2;
    private final String[] cachedLines;
    private ModelPart signModel;

    private SignPostGui(SignPostBlockTile teSign) {
        super((Component)Component.m_237115_((String)"sign.edit"));
        this.tile = teSign;
        this.cachedLines = (String[])IntStream.range(0, 2).mapToObj(teSign.getTextHolder()::getLine).map(Component::getString).toArray(String[]::new);
        this.editLine = !this.tile.getSignUp().active() ? 1 : 0;
    }

    public static void open(SignPostBlockTile teSign) {
        Minecraft.m_91087_().m_91152_((Screen)new SignPostGui(teSign));
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        this.textInputUtil.m_95143_(codePoint);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.hasBothSignsActive()) {
            this.scrollText((int)delta);
            return true;
        }
        return false;
    }

    private boolean hasBothSignsActive() {
        return this.tile.getSignUp().active() && this.tile.getSignDown().active();
    }

    public void scrollText(int amount) {
        this.editLine = Math.floorMod(this.editLine - amount, 2);
        this.textInputUtil.m_95193_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.hasBothSignsActive()) {
            if (keyCode == 265) {
                this.scrollText(1);
                return true;
            }
            if (keyCode == 264 || keyCode == 257 || keyCode == 335) {
                this.scrollText(-1);
                return true;
            }
        }
        return this.textInputUtil.m_95145_(keyCode) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86600_() {
        ++this.updateCounter;
        if (!this.tile.m_58903_().m_155262_(this.tile.m_58900_())) {
            this.close();
        }
    }

    public void m_7379_() {
        this.close();
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundSetTextHolderPacket(this.tile.m_58899_(), this.tile.getTextHolder()));
    }

    private void close() {
        this.tile.m_6596_();
        this.f_96541_.m_91152_(null);
    }

    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120, 200, 20, CommonComponents.f_130655_, p_238847_1_ -> this.close()));
        this.textInputUtil = new TextFieldHelper(() -> this.cachedLines[this.editLine], s -> {
            this.cachedLines[this.editLine] = s;
            this.tile.getTextHolder().setLine(this.editLine, (Component)Component.m_237113_((String)s));
        }, TextFieldHelper.m_95153_((Minecraft)this.f_96541_), TextFieldHelper.m_95182_((Minecraft)this.f_96541_), p_238848_1_ -> this.f_96541_.f_91062_.m_92895_(p_238848_1_) <= 90);
        this.signModel = this.f_96541_.m_167973_().m_171103_(ClientRegistry.SIGN_POST_MODEL);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        Lighting.m_84930_();
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        SignPostGui.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)40, (int)0xFFFFFF);
        MultiBufferSource.BufferSource bufferSource = this.f_96541_.m_91269_().m_110104_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.f_96543_ / 2.0, 0.0, 50.0);
        poseStack.m_85841_(93.75f, -93.75f, 93.75f);
        poseStack.m_85837_(0.0, -1.3125, 0.0);
        poseStack.m_85836_();
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        SignPostBlockTile.Sign signUp = this.tile.getSignUp();
        SignPostBlockTile.Sign signDown = this.tile.getSignDown();
        boolean leftUp = signUp.left();
        boolean leftDown = signDown.left();
        int[] o = new int[]{leftUp ? 1 : -1, leftDown ? 1 : -1};
        boolean blink = this.updateCounter / 6 % 2 == 0;
        poseStack.m_85836_();
        this.renderSign(poseStack, bufferSource, signUp, leftUp);
        poseStack.m_85837_(0.0, -0.5, 0.0);
        this.renderSign(poseStack, bufferSource, signDown, leftDown);
        poseStack.m_85849_();
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        BlockState fence = this.tile.getHeldBlock();
        if (CompatHandler.FRAMEDBLOCKS && this.tile.isFramed()) {
            fence = FramedBlocksCompat.getFramedFence();
        }
        if (fence != null) {
            blockRenderer.m_110912_(fence, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
        }
        poseStack.m_85849_();
        if (signUp.active() || signDown.active()) {
            poseStack.m_85837_((double)(-0.03125f * (float)o[0]), 0.21875, 0.1925);
            poseStack.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
            TextUtil.RenderTextProperties properties = this.tile.getTextHolder().getGUIRenderTextProperties();
            int cursorPos = this.textInputUtil.m_95194_();
            int selectionPos = this.textInputUtil.m_95197_();
            if (signUp.active()) {
                TextUtil.renderGuiLine((TextUtil.RenderTextProperties)properties, (String)this.cachedLines[0], (Font)this.f_96547_, (PoseStack)poseStack, (MultiBufferSource.BufferSource)bufferSource, (int)cursorPos, (int)selectionPos, (this.editLine == 0 ? 1 : 0) != 0, (boolean)blink, (int)-10);
            }
            if (signDown.active()) {
                poseStack.m_85837_((double)(-3 * o[1]), 0.0, 0.0);
                TextUtil.renderGuiLine((TextUtil.RenderTextProperties)properties, (String)this.cachedLines[1], (Font)this.f_96547_, (PoseStack)poseStack, (MultiBufferSource.BufferSource)bufferSource, (int)cursorPos, (int)selectionPos, (this.editLine == 1 ? 1 : 0) != 0, (boolean)blink, (int)38);
            }
        }
        poseStack.m_85849_();
        Lighting.m_84931_();
    }

    private void renderSign(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, SignPostBlockTile.Sign active, boolean leftDown) {
        if (active.active()) {
            poseStack.m_85836_();
            if (!leftDown) {
                poseStack.m_85845_(RotHlpr.YN180);
                poseStack.m_85837_(0.0, 0.0, -0.3125);
            }
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            Material material = ModMaterials.SIGN_POSTS_MATERIALS.get().get(active.woodType());
            VertexConsumer builder = material.m_119194_((MultiBufferSource)bufferSource, RenderType::m_110446_);
            this.signModel.m_104301_(poseStack, builder, 0xF000F0, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
    }
}

