/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.ForgeSlider;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetSpeakerBlockPacket;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SpeakerBlockGui
extends Screen {
    private static final Component NARRATOR_TEXT = Component.m_237115_((String)"gui.supplementaries.speaker_block.chat_message");
    private static final Component CHAT_TEXT = Component.m_237115_((String)"gui.supplementaries.speaker_block.narrator_message");
    private static final Component ACTION_BAR_TEXT = Component.m_237115_((String)"gui.supplementaries.speaker_block.action_bar_message");
    private static final Component TITLE_TEXT = Component.m_237115_((String)"gui.supplementaries.speaker_block.title_message");
    private static final Component DISTANCE_BLOCKS = Component.m_237115_((String)"gui.supplementaries.speaker_block.blocks");
    private static final Component VOLUME_TEXT = Component.m_237115_((String)"gui.supplementaries.speaker_block.volume");
    private static final Component EDIT = Component.m_237115_((String)"gui.supplementaries.speaker_block.edit");
    private EditBox editBox;
    private final SpeakerBlockTile tileSpeaker;
    private SpeakerBlockTile.Mode mode;
    private final String message;
    private Button modeBtn;
    private ForgeSlider volumeSlider;
    private final double initialVolume;

    public SpeakerBlockGui(SpeakerBlockTile te) {
        super(EDIT);
        this.tileSpeaker = te;
        this.mode = this.tileSpeaker.getMode();
        this.message = this.tileSpeaker.getMessage();
        this.initialVolume = this.tileSpeaker.getVolume();
    }

    public static void open(SpeakerBlockTile te) {
        Minecraft.m_91087_().m_91152_((Screen)new SpeakerBlockGui(te));
    }

    public void m_86600_() {
        this.editBox.m_94120_();
    }

    private void updateMode() {
        switch (this.mode) {
            default: {
                this.modeBtn.m_93666_(CHAT_TEXT);
                break;
            }
            case NARRATOR: {
                this.modeBtn.m_93666_(NARRATOR_TEXT);
                break;
            }
            case STATUS_MESSAGE: {
                this.modeBtn.m_93666_(ACTION_BAR_TEXT);
                break;
            }
            case TITLE: {
                this.modeBtn.m_93666_(TITLE_TEXT);
            }
        }
    }

    private void toggleMode() {
        this.mode = SpeakerBlockTile.Mode.values()[(this.mode.ordinal() + 1) % SpeakerBlockTile.Mode.values().length];
        if (!CommonConfigs.Blocks.SPEAKER_NARRATOR.get().booleanValue() && this.mode == SpeakerBlockTile.Mode.NARRATOR) {
            this.mode = SpeakerBlockTile.Mode.CHAT;
        }
    }

    public void m_7856_() {
        assert (this.f_96541_ != null);
        this.f_96541_.f_91068_.m_90926_(true);
        int range = CommonConfigs.Blocks.SPEAKER_RANGE.get();
        this.volumeSlider = new ForgeSlider(this.f_96543_ / 2 - 75, this.f_96544_ / 4 + 80, 150, 20, VOLUME_TEXT, DISTANCE_BLOCKS, 1.0, range, this.initialVolume, 1.0, 1, true);
        this.m_142416_((GuiEventListener)this.volumeSlider);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120, 200, 20, CommonComponents.f_130655_, p_214266_1_ -> this.onDone()));
        this.modeBtn = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 75, this.f_96544_ / 4 + 50, 150, 20, CHAT_TEXT, p_214186_1_ -> {
            this.toggleMode();
            this.updateMode();
        }));
        if (!CommonConfigs.Blocks.SPEAKER_NARRATOR.get().booleanValue()) {
            this.modeBtn.f_93623_ = false;
        }
        this.updateMode();
        this.editBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 10, 200, 20, this.f_96539_){

            protected MutableComponent m_5646_() {
                return super.m_5646_();
            }
        };
        this.editBox.m_94144_(this.message);
        this.editBox.m_94199_(32);
        this.m_142416_((GuiEventListener)this.editBox);
        this.m_94718_((GuiEventListener)this.editBox);
        this.editBox.m_94178_(true);
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
        this.tileSpeaker.setMode(this.mode);
        this.tileSpeaker.setMessage(this.editBox.m_94155_());
        this.tileSpeaker.setVolume(this.volumeSlider.getValue());
        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundSetSpeakerBlockPacket(this.tileSpeaker.m_58899_(), this.tileSpeaker.getMessage(), this.tileSpeaker.getMode(), this.tileSpeaker.getVolume()));
    }

    private void onDone() {
        this.tileSpeaker.m_6596_();
        this.f_96541_.m_91152_(null);
    }

    public void m_7379_() {
        this.onDone();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ != 257 && p_keyPressed_1_ != 335) {
            return false;
        }
        this.onDone();
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.volumeSlider == this.m_7222_() && button == 0) {
            this.volumeSlider.m_7691_(mouseX, mouseY);
            this.m_7522_((GuiEventListener)this.editBox);
            this.editBox.m_94178_(true);
        }
        return true;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        SpeakerBlockGui.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)40, (int)0xFFFFFF);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

