/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Arrays;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherArmBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpringLauncherArmBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpringLauncherHeadBlock
extends DirectionalBlock {
    protected static final VoxelShape PISTON_EXTENSION_EAST_AABB = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_EXTENSION_WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_EXTENSION_SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_EXTENSION_NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    protected static final VoxelShape PISTON_EXTENSION_UP_AABB = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_EXTENSION_DOWN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final VoxelShape UP_ARM_AABB = Block.m_49796_((double)1.0, (double)-4.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    protected static final VoxelShape DOWN_ARM_AABB = Block.m_49796_((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)20.0, (double)15.0);
    protected static final VoxelShape SOUTH_ARM_AABB = Block.m_49796_((double)1.0, (double)1.0, (double)-4.0, (double)15.0, (double)15.0, (double)12.0);
    protected static final VoxelShape NORTH_ARM_AABB = Block.m_49796_((double)1.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0, (double)20.0);
    protected static final VoxelShape EAST_ARM_AABB = Block.m_49796_((double)-4.0, (double)1.0, (double)1.0, (double)12.0, (double)15.0, (double)15.0);
    protected static final VoxelShape WEST_ARM_AABB = Block.m_49796_((double)4.0, (double)1.0, (double)1.0, (double)20.0, (double)15.0, (double)15.0);
    protected static final VoxelShape SHORT_UP_ARM_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    protected static final VoxelShape SHORT_DOWN_ARM_AABB = Block.m_49796_((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SHORT_SOUTH_ARM_AABB = Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)12.0);
    protected static final VoxelShape SHORT_NORTH_ARM_AABB = Block.m_49796_((double)1.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0, (double)16.0);
    protected static final VoxelShape SHORT_EAST_ARM_AABB = Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)12.0, (double)15.0, (double)15.0);
    protected static final VoxelShape SHORT_WEST_ARM_AABB = Block.m_49796_((double)4.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape[] EXTENDED_SHAPES = SpringLauncherHeadBlock.getShapesForExtension(true);
    private static final VoxelShape[] UNEXTENDED_SHAPES = SpringLauncherHeadBlock.getShapesForExtension(false);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty SHORT = BlockStateProperties.f_61449_;

    public SpringLauncherHeadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SHORT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static VoxelShape[] getShapesForExtension(boolean extended) {
        return (VoxelShape[])Arrays.stream(Direction.values()).map(direction -> SpringLauncherHeadBlock.getShapeForDirection(direction, extended)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape getShapeForDirection(Direction direction, boolean shortArm) {
        return switch (direction) {
            default -> Shapes.m_83110_((VoxelShape)PISTON_EXTENSION_DOWN_AABB, (VoxelShape)(shortArm ? SHORT_DOWN_ARM_AABB : DOWN_ARM_AABB));
            case Direction.UP -> Shapes.m_83110_((VoxelShape)PISTON_EXTENSION_UP_AABB, (VoxelShape)(shortArm ? SHORT_UP_ARM_AABB : UP_ARM_AABB));
            case Direction.NORTH -> Shapes.m_83110_((VoxelShape)PISTON_EXTENSION_NORTH_AABB, (VoxelShape)(shortArm ? SHORT_NORTH_ARM_AABB : NORTH_ARM_AABB));
            case Direction.SOUTH -> Shapes.m_83110_((VoxelShape)PISTON_EXTENSION_SOUTH_AABB, (VoxelShape)(shortArm ? SHORT_SOUTH_ARM_AABB : SOUTH_ARM_AABB));
            case Direction.WEST -> Shapes.m_83110_((VoxelShape)PISTON_EXTENSION_WEST_AABB, (VoxelShape)(shortArm ? SHORT_WEST_ARM_AABB : WEST_ARM_AABB));
            case Direction.EAST -> Shapes.m_83110_((VoxelShape)PISTON_EXTENSION_EAST_AABB, (VoxelShape)(shortArm ? SHORT_EAST_ARM_AABB : EAST_ARM_AABB));
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ((Boolean)state.m_61143_((Property)SHORT) != false ? EXTENDED_SHAPES : UNEXTENDED_SHAPES)[((Direction)state.m_61143_((Property)FACING)).ordinal()];
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn.m_20162_() || state.m_61143_((Property)FACING) != Direction.UP) {
            super.m_142072_(worldIn, state, pos, entityIn, fallDistance);
        } else {
            entityIn.m_142535_(fallDistance, 0.0f, DamageSource.f_19315_);
            if (entityIn instanceof LivingEntity && !worldIn.f_46443_ && fallDistance > (float)CommonConfigs.Blocks.LAUNCHER_HEIGHT.get().intValue()) {
                worldIn.m_7731_(pos, (BlockState)((BlockState)ModRegistry.SPRING_LAUNCHER_ARM.get().m_49966_().m_61124_((Property)SpringLauncherArmBlock.EXTENDING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 3);
                BlockEntity blockEntity = worldIn.m_7702_(pos);
                if (blockEntity instanceof SpringLauncherArmBlockTile) {
                    SpringLauncherArmBlockTile tile = (SpringLauncherArmBlockTile)blockEntity;
                    tile.retractOnFallOn();
                }
            }
        }
    }

    private void bounceEntity(Entity entity) {
        Vec3 vector3d = entity.m_20184_();
        if (vector3d.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vector3d.f_82479_, -vector3d.f_82480_ * d0, vector3d.f_82481_);
        }
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHORT});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ModRegistry.SPRING_LAUNCHER.get());
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        Block block;
        if (!worldIn.f_46443_ && player.m_150110_().f_35937_ && (block = worldIn.m_8055_(blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60734_()) instanceof SpringLauncherBlock) {
            worldIn.m_7471_(blockpos, false);
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockState comp = (BlockState)((BlockState)ModRegistry.SPRING_LAUNCHER_ARM.get().m_49966_().m_61124_((Property)SpringLauncherArmBlock.EXTENDING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)));
        if (state.m_60734_() != newState.m_60734_() && newState != comp) {
            super.m_6810_(state, worldIn, pos, newState, isMoving);
            Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
            pos = pos.m_121945_(direction);
            BlockState blockstate = worldIn.m_8055_(pos);
            if (blockstate.m_60734_() instanceof SpringLauncherBlock && ((Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61432_)).booleanValue()) {
                SpringLauncherHeadBlock.m_49950_((BlockState)blockstate, (Level)worldIn, (BlockPos)pos);
                worldIn.m_7471_(pos, false);
            }
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.m_122424_() == stateIn.m_61143_((Property)FACING) && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState bs = worldIn.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()));
        return bs == ((BlockState)ModRegistry.SPRING_LAUNCHER.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61432_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.m_60710_((LevelReader)worldIn, pos)) {
            BlockPos blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
            worldIn.m_8055_(blockpos).m_60690_(worldIn, blockpos, blockIn, fromPos, false);
        }
    }
}

