/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BambooSpikesBlockTile
extends BlockEntity {
    public Potion potion = Potions.f_43598_;
    public int charges = 0;
    public long lastTicked = 0L;
    public static final float POTION_MULTIPLIER = 0.1f;
    public static final int MAX_CHARGES = 16;

    public BambooSpikesBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.BAMBOO_SPIKES_TILE.get(), pos, state);
    }

    public int getColor() {
        if (this.hasPotion()) {
            return PotionUtils.m_43559_((Potion)this.potion);
        }
        return 0xFFFFFF;
    }

    public boolean hasPotion() {
        return this.potion != Potions.f_43598_ && this.charges != 0;
    }

    public boolean isOnCooldown(Level world) {
        return world.m_46467_() - this.lastTicked < 20L;
    }

    public boolean consumeCharge(Level world) {
        if (CommonConfigs.Blocks.BAMBOO_SPIKES_ALTERNATIVE.get().booleanValue() && !((MobEffectInstance)this.potion.m_43488_().get(0)).m_19544_().m_19486_()) {
            return false;
        }
        this.lastTicked = world.m_46467_();
        --this.charges;
        this.m_6596_();
        if (this.charges <= 0) {
            this.charges = 0;
            this.potion = Potions.f_43598_;
            return true;
        }
        return false;
    }

    public void setMissingCharges(int missing) {
        this.charges = Math.max(16 - missing, 0);
    }

    public boolean tryApplyPotion(Potion newPotion) {
        if ((this.charges == 0 || this.potion == Potions.f_43598_ || this.potion.equals(newPotion) && this.charges != 16) && BambooSpikesTippedItem.areEffectsValid(newPotion.m_43488_())) {
            this.potion = newPotion;
            this.charges = 16;
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            return true;
        }
        return false;
    }

    public boolean interactWithEntity(LivingEntity le, @Nonnull Level world) {
        if (this.hasPotion() && !this.isOnCooldown(world)) {
            boolean used = false;
            for (MobEffectInstance effect : this.potion.m_43488_()) {
                if (!le.m_7301_(effect) || le.m_21023_(effect.m_19544_())) continue;
                if (effect.m_19544_().m_8093_()) {
                    float health = 0.5f;
                    effect.m_19544_().m_19461_(null, null, le, effect.m_19564_(), (double)health);
                } else {
                    le.m_7292_(new MobEffectInstance(effect.m_19544_(), (int)((float)effect.m_19557_() * 0.1f), effect.m_19564_()));
                }
                used = true;
            }
            if (used) {
                this.makeParticle(world);
                return this.consumeCharge(world);
            }
        }
        return false;
    }

    public void makeParticle(Level level) {
        int i = this.getColor();
        double d0 = (double)(i >> 16 & 0xFF) / 255.0;
        double d1 = (double)(i >> 8 & 0xFF) / 255.0;
        double d2 = (double)(i & 0xFF) / 255.0;
        BlockPos pos = this.m_58899_();
        level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5 + ((double)level.f_46441_.m_188501_() - 0.5) * 0.75, (double)pos.m_123342_() + 0.5 + ((double)level.f_46441_.m_188501_() - 0.5) * 0.75, (double)pos.m_123343_() + 0.5 + ((double)level.f_46441_.m_188501_() - 0.5) * 0.75, d0, d1, d2);
    }

    public ItemStack getSpikeItem() {
        if (this.hasPotion()) {
            ItemStack stack = BambooSpikesTippedItem.makeSpikeItem(this.potion);
            stack.m_41721_(stack.m_41776_() - this.charges);
            return stack;
        }
        return new ItemStack((ItemLike)ModRegistry.BAMBOO_SPIKES_ITEM.get());
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("Charges", this.charges);
        compound.m_128356_("LastTicked", this.lastTicked);
        ResourceLocation resourcelocation = Registry.f_122828_.m_7981_((Object)this.potion);
        compound.m_128359_("Potion", resourcelocation.toString());
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.charges = compound.m_128451_("Charges");
        this.lastTicked = compound.m_128454_("LastTicked");
        this.potion = PotionUtils.m_43577_((CompoundTag)compound);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

