/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FaucetBlock;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;

public class FaucetBlockTile
extends BlockEntity {
    private static final List<IBlockSourceInteraction> BLOCK_INTERACTIONS = new ArrayList<IBlockSourceInteraction>();
    private static final List<ITileSourceInteraction> TILE_INTERACTIONS = new ArrayList<ITileSourceInteraction>();
    private static final List<IFluidSourceInteraction> FLUID_INTERACTIONS = new ArrayList<IFluidSourceInteraction>();
    private static final List<IBlockTargetInteraction> TARGET_BLOCK_INTERACTIONS = new ArrayList<IBlockTargetInteraction>();
    private static final List<ITileTargetInteraction> TARGET_TILE_INTERACTIONS = new ArrayList<ITileTargetInteraction>();
    private static final int COOLDOWN = 20;
    private int transferCooldown = 0;
    public final SoftFluidTank tempFluidHolder = SoftFluidTank.create((int)5);

    public FaucetBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.FAUCET_TILE.get(), pos, state);
    }

    public void updateLight() {
        if (this.f_58857_ == null) {
            return;
        }
        int light = this.tempFluidHolder.getFluid().getLuminosity();
        if (light != 0) {
            light = (int)Mth.m_14036_((float)((float)light / 2.0f), (float)1.0f, (float)7.0f);
        }
        if (light != (Integer)this.m_58900_().m_61143_((Property)FaucetBlock.LIGHT_LEVEL)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FaucetBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    @PlatformOnly(value={"forge"})
    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_7918_(0, -1, 0), this.m_58899_().m_7918_(1, 1, 1));
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, FaucetBlockTile tile) {
        boolean flag;
        if (tile.transferCooldown > 0) {
            --tile.transferCooldown;
        } else if (tile.isOpen() && (flag = tile.tryExtract(pLevel, pPos, pState, true))) {
            tile.transferCooldown += 20;
        }
    }

    public boolean updateContainedFluidVisuals(Level level, BlockPos pos, BlockState state) {
        FluidState fluidState = level.m_6425_(pos.m_121945_(((Direction)state.m_61143_((Property)FaucetBlock.FACING)).m_122424_()));
        if (!fluidState.m_76178_() && fluidState.m_76170_()) {
            SoftFluid f = SoftFluidRegistry.fromForgeFluid((Fluid)fluidState.m_76152_());
            if (f != null) {
                this.tempFluidHolder.fill(f);
                this.updateLight();
                return true;
            }
            boolean bl = true;
        }
        boolean r = this.tryExtract(level, pos, state, false);
        this.updateLight();
        return r;
    }

    private boolean tryExtract(Level level, BlockPos pos, BlockState state, boolean doTransfer) {
        BlockEntity tileBack;
        Direction dir = (Direction)state.m_61143_((Property)FaucetBlock.FACING);
        BlockPos behind = pos.m_121945_(dir.m_122424_());
        BlockState backState = level.m_8055_(behind);
        this.tempFluidHolder.clear();
        if (backState.m_60795_()) {
            return false;
        }
        for (IBlockSourceInteraction iBlockSourceInteraction : BLOCK_INTERACTIONS) {
            InteractionResult res = iBlockSourceInteraction.tryDrain(level, this.tempFluidHolder, behind, backState, () -> doTransfer && this.tryFillingBlockBelow());
            if (res == InteractionResult.PASS) continue;
            if (res == InteractionResult.SUCCESS) {
                return true;
            }
            if (res == InteractionResult.CONSUME) break;
            if (res != InteractionResult.FAIL) continue;
            return false;
        }
        if ((tileBack = level.m_7702_(behind)) != null) {
            for (ITileSourceInteraction bi : TILE_INTERACTIONS) {
                InteractionResult res = bi.tryDrain(level, this.tempFluidHolder, behind, tileBack, dir, () -> doTransfer && this.tryFillingBlockBelow());
                if (res == InteractionResult.PASS) continue;
                if (res == InteractionResult.SUCCESS) {
                    return true;
                }
                if (res == InteractionResult.CONSUME) break;
                if (res != InteractionResult.FAIL) continue;
                return false;
            }
            if (!doTransfer) {
                return !this.tempFluidHolder.isEmpty();
            }
            return this.spillItemsFromInventory(level, pos, dir, tileBack);
        }
        FluidState fluidState = level.m_6425_(behind);
        for (IFluidSourceInteraction bi : FLUID_INTERACTIONS) {
            InteractionResult res = bi.tryDrain(level, this.tempFluidHolder, behind, fluidState, () -> doTransfer && this.tryFillingBlockBelow());
            if (res == InteractionResult.PASS) continue;
            if (res == InteractionResult.SUCCESS) {
                return true;
            }
            if (res == InteractionResult.CONSUME) break;
            if (res != InteractionResult.FAIL) continue;
            return false;
        }
        if (!doTransfer) {
            return !this.tempFluidHolder.isEmpty();
        }
        return false;
    }

    private boolean tryFillingBlockBelow() {
        BlockEntity tileBelow;
        SoftFluid softFluid = this.tempFluidHolder.getFluid();
        if (softFluid.isEmpty()) {
            return false;
        }
        BlockPos below = this.f_58858_.m_7495_();
        BlockState belowState = this.f_58857_.m_8055_(below);
        for (IBlockTargetInteraction bi : TARGET_BLOCK_INTERACTIONS) {
            InteractionResult res = bi.tryFill(this.f_58857_, this.tempFluidHolder, below, belowState);
            if (res == InteractionResult.PASS) continue;
            if (res == InteractionResult.SUCCESS) {
                return true;
            }
            if (res == InteractionResult.CONSUME) break;
            if (res != InteractionResult.FAIL) continue;
            return false;
        }
        if ((tileBelow = this.f_58857_.m_7702_(below)) != null) {
            for (ITileTargetInteraction bi : TARGET_TILE_INTERACTIONS) {
                InteractionResult res = bi.tryFill(this.f_58857_, this.tempFluidHolder, below, tileBelow);
                if (res == InteractionResult.PASS) continue;
                if (res == InteractionResult.SUCCESS) {
                    return true;
                }
                if (res == InteractionResult.CONSUME) break;
                if (res != InteractionResult.FAIL) continue;
                return false;
            }
        }
        return false;
    }

    public boolean isOpen() {
        return (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_) ^ (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61431_);
    }

    public boolean hasWater() {
        return (Boolean)this.m_58900_().m_61143_((Property)FaucetBlock.HAS_WATER);
    }

    public boolean isConnectedBelow() {
        return (Boolean)this.m_58900_().m_61143_((Property)FaucetBlock.HAS_JAR);
    }

    public boolean spillItemsFromInventory(Level level, BlockPos pos, Direction dir, BlockEntity tile) {
        if (this.isConnectedBelow()) {
            return false;
        }
        return ItemsUtil.faucetSpillItems(level, pos, dir, tile);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.transferCooldown = compound.m_128451_("TransferCooldown");
        this.tempFluidHolder.load(compound);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("TransferCooldown", this.transferCooldown);
        this.tempFluidHolder.save(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void registerInteraction(Object interaction) {
        Object bs;
        boolean success = false;
        if (interaction instanceof IBlockSourceInteraction) {
            bs = (IBlockSourceInteraction)interaction;
            BLOCK_INTERACTIONS.add((IBlockSourceInteraction)bs);
            success = true;
        }
        if (interaction instanceof ITileSourceInteraction) {
            ITileSourceInteraction ts = (ITileSourceInteraction)interaction;
            TILE_INTERACTIONS.add(ts);
            success = true;
        }
        if (interaction instanceof IFluidSourceInteraction) {
            bs = (IFluidSourceInteraction)interaction;
            FLUID_INTERACTIONS.add((IFluidSourceInteraction)bs);
            success = true;
        }
        if (interaction instanceof IBlockTargetInteraction) {
            IBlockTargetInteraction tb = (IBlockTargetInteraction)interaction;
            TARGET_BLOCK_INTERACTIONS.add(tb);
            success = true;
        }
        if (interaction instanceof ITileTargetInteraction) {
            ITileTargetInteraction tt = (ITileTargetInteraction)interaction;
            TARGET_TILE_INTERACTIONS.add(tt);
            success = true;
        }
        if (!success) {
            throw new UnsupportedOperationException("Unsupported faucet interaction class: " + interaction.getClass().getSimpleName());
        }
    }

    public static interface IBlockSourceInteraction {
        public InteractionResult tryDrain(Level var1, SoftFluidTank var2, BlockPos var3, BlockState var4, FillAction var5);

        default public int getTransferCooldown() {
            return 20;
        }
    }

    @FunctionalInterface
    public static interface FillAction {
        public boolean tryExecute();
    }

    public static interface ITileSourceInteraction {
        public InteractionResult tryDrain(Level var1, SoftFluidTank var2, BlockPos var3, BlockEntity var4, Direction var5, FillAction var6);

        default public int getTransferCooldown() {
            return 20;
        }
    }

    public static interface IFluidSourceInteraction {
        public InteractionResult tryDrain(Level var1, SoftFluidTank var2, BlockPos var3, FluidState var4, FillAction var5);

        default public int getTransferCooldown() {
            return 20;
        }
    }

    public static interface IBlockTargetInteraction {
        public InteractionResult tryFill(Level var1, SoftFluidTank var2, BlockPos var3, BlockState var4);
    }

    public static interface ITileTargetInteraction {
        public InteractionResult tryFill(Level var1, SoftFluidTank var2, BlockPos var3, BlockEntity var4);
    }
}

