/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.client.screens.HangingSignGui;
import net.mehvahdjukaar.supplementaries.common.block.IMapDisplay;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SwayingBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class HangingSignBlockTile
extends SwayingBlockTile
implements IMapDisplay,
ITextHolderProvider,
IOwnerProtected {
    public static final int MAX_LINES = 7;
    public final WoodType woodType;
    private boolean fakeItem = true;
    private UUID owner = null;
    private TextHolder textHolder;
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public HangingSignBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.HANGING_SIGN_TILE.get(), pos, state);
        this.textHolder = new TextHolder(7, 75);
        Block block = this.m_58900_().m_60734_();
        if (block instanceof HangingSignBlock) {
            HangingSignBlock block2 = (HangingSignBlock)block;
            this.woodType = block2.woodType;
        } else {
            this.woodType = WoodTypeRegistry.OAK_TYPE;
        }
    }

    public boolean hasFakeItem() {
        return this.fakeItem;
    }

    public void setFakeItem(boolean fakeItem) {
        this.fakeItem = fakeItem;
    }

    @Override
    public boolean isAlwaysFast() {
        return ClientConfigs.Blocks.FAST_SIGNS.get();
    }

    @Override
    public boolean isFlipped() {
        return this.m_58900_().m_61143_(HangingSignBlock.AXIS) != Direction.Axis.Z;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    public TextHolder getTextHolder() {
        return this.textHolder;
    }

    public void openScreen(Level level, BlockPos pos, Player player) {
        HangingSignGui.open(this);
    }

    @Override
    public ItemStack getMapStack() {
        return this.getItem();
    }

    @Override
    public void m_6596_() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        super.m_6596_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.stacks = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.stacks);
        this.textHolder.load(tag);
        this.loadOwner(tag);
        if (tag.m_128441_("FakeItem")) {
            this.fakeItem = tag.m_128471_("FakeItem");
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.stacks);
        this.textHolder.save(tag);
        this.saveOwner(tag);
        if (this.fakeItem) {
            tag.m_128379_("FakeItem", true);
        }
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack removeItem() {
        return ContainerHelper.m_18966_(this.stacks, (int)0);
    }

    public void setItem(ItemStack item) {
        this.stacks = NonNullList.m_122780_((int)1, (Object)item);
    }

    public ItemStack getItem() {
        return (ItemStack)this.stacks.get(0);
    }

    @Override
    public Vec3i getNormalRotationAxis(BlockState state) {
        return state.m_61143_(HangingSignBlock.AXIS) == Direction.Axis.X ? new Vec3i(0, 0, -1) : new Vec3i(1, 0, 0);
    }

    static {
        maxSwingAngle = 45.0f;
        minSwingAngle = 2.5f;
        maxPeriod = 25.0f;
        angleDamping = 150.0f;
        periodDamping = 100.0f;
    }
}

