/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SafeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity;
import net.mehvahdjukaar.supplementaries.common.inventories.SackContainerMenu;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SackBlockTile
extends OpeneableContainerBlockEntity {
    public SackBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.SACK_TILE.get(), pos, state, 27);
    }

    @Override
    public int m_6643_() {
        return SackBlockTile.getUnlockedSlots();
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"block.supplementaries.sack");
    }

    @Override
    protected void playOpenSound(BlockState state) {
        double d0 = (double)this.f_58858_.m_123341_() + 0.5;
        double d1 = (double)this.f_58858_.m_123342_() + 1.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5;
        this.f_58857_.m_6263_(null, d0, d1, d2, ModSounds.SACK_OPEN.get(), SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.95f);
    }

    @Override
    protected void playCloseSound(BlockState state) {
        double d0 = (double)this.f_58858_.m_123341_() + 0.5;
        double d1 = (double)this.f_58858_.m_123342_() + 1.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5;
        this.f_58857_.m_6263_(null, d0, d1, d2, ModSounds.SACK_OPEN.get(), SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.8f);
    }

    @Override
    protected void updateBlockState(BlockState state, boolean open) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)SafeBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag) && tag.m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)this.items);
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18976_((CompoundTag)tag, (NonNullList)this.items, (boolean)false);
        }
    }

    public AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new SackContainerMenu(id, player, (Container)this);
    }

    public static int getUnlockedSlots() {
        return CommonConfigs.Blocks.SACK_SLOTS.get();
    }

    public boolean isSlotUnlocked(int ind) {
        return ind < SackBlockTile.getUnlockedSlots();
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.isSlotUnlocked(index) && MiscUtils.isAllowedInShulker(stack);
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return this.isSlotUnlocked(index);
    }

    public boolean acceptsTransfer(Player player) {
        return true;
    }
}

