/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.serialization.DynamicOps;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.client.screens.SignPostGui;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FramedBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SignPostBlockTile
extends MimicBlockTile
implements ITextHolderProvider,
IOwnerProtected,
IExtraModelDataProvider {
    public static final ModelDataKey<Boolean> FRAMED = ModBlockProperties.FRAMED;
    private final TextHolder textHolder;
    private final Sign signUp = new Sign(false, true, 0.0f, WoodTypeRegistry.OAK_TYPE);
    private final Sign signDown = new Sign(false, false, 0.0f, WoodTypeRegistry.OAK_TYPE);
    private UUID owner = null;
    private boolean isSlim = false;
    private boolean framed = false;

    public SignPostBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.SIGN_POST_TILE.get(), pos, state);
        this.textHolder = new TextHolder(2, 90);
    }

    public ExtraModelData getExtraModelData() {
        return ExtraModelData.builder().with(FRAMED, (Object)this.framed).with(MIMIC, (Object)this.getHeldBlock()).build();
    }

    @Override
    public TextHolder getTextHolder() {
        return this.textHolder;
    }

    @PlatformOnly(value={"forge"})
    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_7637_(-0.25, 0.0, -0.25), this.m_58899_().m_7637_(1.25, 1.0, 1.25));
    }

    public void pointToward(BlockPos targetPos, boolean up) {
        float yaw = (float)(Math.atan2((double)targetPos.m_123341_() - (double)this.f_58858_.m_123341_(), (double)targetPos.m_123343_() - (double)this.f_58858_.m_123343_()) * 180.0 / Math.PI);
        if (up) {
            this.signUp.setYaw(yaw);
        } else {
            this.signDown.setYaw(yaw);
        }
    }

    public float getPointingYaw(boolean up) {
        if (up) {
            return this.signUp.getPointing();
        }
        return this.signDown.getPointing();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.framed = compound.m_128471_("Framed");
        this.textHolder.load(compound);
        if (compound.m_128441_("YawUp")) {
            this.signUp.yaw = compound.m_128457_("YawUp");
            this.signDown.yaw = compound.m_128457_("YawDown");
            this.signUp.left = compound.m_128471_("LeftUp");
            this.signDown.left = compound.m_128471_("LeftDown");
            this.signUp.active = compound.m_128471_("Up");
            this.signDown.active = compound.m_128471_("Down");
            this.signUp.woodType = WoodTypeRegistry.fromNBT((String)compound.m_128461_("TypeUp"));
            this.signDown.woodType = WoodTypeRegistry.fromNBT((String)compound.m_128461_("TypeDown"));
        } else {
            this.signUp.load(compound.m_128469_("SignUp"));
            this.signUp.load(compound.m_128469_("SignDown"));
        }
        this.loadOwner(compound);
        this.isSlim = this.mimic.m_60734_() instanceof StickBlock;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("Framed", this.framed);
        this.textHolder.save(compound);
        compound.m_128365_("SignUp", (Tag)this.signUp.save());
        compound.m_128365_("SignDown", (Tag)this.signUp.save());
        this.saveOwner(compound);
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public boolean rotateSign(boolean up, float angle, boolean constrainAngle) {
        if (up && this.signUp.active) {
            this.signUp.rotateBy(angle, constrainAngle);
            return true;
        }
        if (this.signDown.active) {
            this.signDown.rotateBy(angle, constrainAngle);
            return true;
        }
        return false;
    }

    public void openScreen(Level level, BlockPos pos, Player player) {
        SignPostGui.open(this);
    }

    public boolean isSlim() {
        return this.isSlim;
    }

    public Sign getSignUp() {
        return this.signUp;
    }

    public Sign getSignDown() {
        return this.signDown;
    }

    public Sign getSign(boolean up) {
        return up ? this.getSignUp() : this.getSignDown();
    }

    public boolean isFramed() {
        return this.framed;
    }

    public boolean initializeSignAfterConversion(WoodType woodType, int r, boolean up, boolean slim, boolean framed) {
        Sign sign = this.getSign(up);
        if (!sign.active) {
            sign.active = true;
            sign.woodType = woodType;
            sign.yaw = 90.0f + (float)r * -22.5f;
            this.framed = framed;
            this.isSlim = slim;
            return true;
        }
        return false;
    }

    public InteractionResult handleInteraction(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, ItemStack itemstack, Item item, SignPostBlockTile tile) {
        boolean isSneaking;
        boolean emptyHand = itemstack.m_41619_();
        boolean bl = isSneaking = player.m_6144_() && emptyHand;
        if (hit.m_82434_().m_122434_() != Direction.Axis.Y) {
            InteractionResult result = tile.getTextHolder().playerInteract(level, pos, player, handIn, (BlockEntity)tile);
            if (result != InteractionResult.PASS) {
                return result;
            }
            if (isSneaking) {
                tile.getSign(this.getClickedSign(hit.m_82450_())).toggleDirection();
                tile.m_6596_();
                level.m_7260_(pos, state, state, 3);
                level.m_5594_(null, pos, SoundEvents.f_12017_, SoundSource.BLOCKS, 1.0f, 0.6f);
                return InteractionResult.CONSUME;
            }
            if (item instanceof CompassItem) {
                BlockPos pointingPos;
                BlockPos blockPos = pointingPos = CompassItem.m_40736_((ItemStack)itemstack) ? this.getLodestonePos(level, itemstack) : this.getWorldSpawnPos(level);
                if (pointingPos != null) {
                    boolean up = this.getClickedSign(hit.m_82450_());
                    Sign s = this.getSign(up);
                    if (s.active) {
                        tile.pointToward(pointingPos, up);
                    }
                    tile.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.FAIL;
            }
            if (CompatHandler.FRAMEDBLOCKS && tile.framed) {
                boolean success = FramedBlocksCompat.interactWithFramedSignPost(tile, player, handIn, itemstack, level, pos);
                if (success) {
                    return InteractionResult.CONSUME;
                }
            } else if (item instanceof SignPostItem) {
                return InteractionResult.PASS;
            }
        }
        tile.sendOpenGuiPacket(level, pos, player);
        return InteractionResult.CONSUME;
    }

    public boolean getClickedSign(Vec3 hit) {
        double y = hit.f_82480_;
        y = y < 0.0 ? (y += (double)(1 - (int)y)) : (y -= (double)((int)y));
        return y > 0.5;
    }

    @Nullable
    private BlockPos getLodestonePos(Level world, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            Optional optional;
            boolean flag = tag.m_128441_("LodestonePos");
            boolean flag1 = tag.m_128441_("LodestoneDimension");
            if (flag && flag1 && (optional = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("LodestoneDimension")).result()).isPresent() && world.m_46472_() == optional.get()) {
                return NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LodestonePos"));
            }
        }
        return null;
    }

    @Nullable
    private BlockPos getWorldSpawnPos(Level world) {
        return world.m_6042_().f_63858_() ? new BlockPos(world.m_6106_().m_6789_(), world.m_6106_().m_6527_(), world.m_6106_().m_6526_()) : null;
    }

    public static final class Sign {
        private boolean active;
        private boolean left;
        private float yaw;
        private WoodType woodType;

        private Sign(boolean active, boolean left, float yaw, WoodType woodType) {
            this.active = active;
            this.left = left;
            this.yaw = yaw;
            this.woodType = woodType;
        }

        public void load(CompoundTag compound) {
            this.active = compound.m_128471_("Active");
            this.left = compound.m_128471_("Left");
            this.yaw = compound.m_128457_("Yaw");
            this.woodType = WoodTypeRegistry.fromNBT((String)compound.m_128461_("WoodType"));
        }

        public CompoundTag save() {
            CompoundTag compound = new CompoundTag();
            compound.m_128350_("Yaw", this.yaw);
            compound.m_128379_("Left", this.left);
            compound.m_128379_("Active", this.active);
            compound.m_128359_("WoodType", this.woodType.toString());
            return compound;
        }

        private float getPointing() {
            return Mth.m_14177_((float)(-this.yaw - (float)(this.left ? 180 : 0)));
        }

        private void setYaw(float yaw) {
            this.yaw = Mth.m_14177_((float)(yaw - (float)(this.left ? 180 : 0)));
        }

        private void rotateBy(float angle, boolean constrainAngle) {
            this.yaw = Mth.m_14177_((float)(this.yaw + angle));
            if (constrainAngle) {
                this.yaw -= this.yaw % 22.5f;
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setLeft(boolean left) {
            this.left = left;
        }

        public void setWoodType(WoodType woodType) {
            this.woodType = woodType;
        }

        public boolean active() {
            return this.active;
        }

        public boolean left() {
            return this.left;
        }

        public float yaw() {
            return this.yaw;
        }

        public WoodType woodType() {
            return this.woodType;
        }

        public void toggleDirection() {
            this.left = !this.left;
        }

        public ItemStack getItem() {
            return new ItemStack((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(this.woodType));
        }
    }
}

