/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.integration.MapAtlasCompat;
import net.mehvahdjukaar.moonlight.api.map.MapHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.api.IExtendedItem;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.DirectionalCakeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.DoubleCakeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.EndermanSkullBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GlobeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.JarBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CandleSkullBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.DoubleSkullBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.ThrowableBrickEntity;
import net.mehvahdjukaar.supplementaries.common.items.JarItem;
import net.mehvahdjukaar.supplementaries.common.items.additional_behaviors.SimplePlacement;
import net.mehvahdjukaar.supplementaries.common.items.additional_behaviors.WallLanternPlacement;
import net.mehvahdjukaar.supplementaries.common.misc.AntiqueInkHelper;
import net.mehvahdjukaar.supplementaries.common.misc.SoapWashableHelper;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.FarmersDelightCompat;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ItemsOverrideHandler {
    private static final Map<Item, ItemUseOnBlockOverride> HP_ON_BLOCK_OVERRIDES = new IdentityHashMap<Item, ItemUseOnBlockOverride>();
    private static final Map<Item, ItemUseOnBlockOverride> ON_BLOCK_OVERRIDES = new IdentityHashMap<Item, ItemUseOnBlockOverride>();
    private static final Map<Item, ItemUseOverride> ITEM_USE_OVERRIDES = new IdentityHashMap<Item, ItemUseOverride>();
    private static final Map<Block, BlockInteractedWithOverride> BLOCK_USE_OVERRIDES = new IdentityHashMap<Block, BlockInteractedWithOverride>();

    public static boolean hasBlockPlacementAssociated(Item item) {
        ItemUseOnBlockOverride override = ON_BLOCK_OVERRIDES.get(item);
        return override != null;
    }

    public static void registerOverrides() {
        ArrayList<ItemUseOnBlockOverride> HPItemActionOnBlock = new ArrayList<ItemUseOnBlockOverride>();
        ArrayList<ItemUseOnBlockOverride> itemActionOnBlock = new ArrayList<ItemUseOnBlockOverride>();
        ArrayList<ItemUseOverride> itemAction = new ArrayList<ItemUseOverride>();
        ArrayList<BlockInteractedWithOverride> actionOnBlock = new ArrayList<BlockInteractedWithOverride>();
        actionOnBlock.add(new DirectionalCakeConversionBehavior());
        actionOnBlock.add(new BellChainBehavior());
        actionOnBlock.add(new FDStickBehavior());
        itemAction.add(new ThrowableBrickBehavior());
        itemAction.add(new ClockItemBehavior());
        itemAction.add(new CompassItemBehavior());
        HPItemActionOnBlock.add(new AntiqueInkBehavior());
        HPItemActionOnBlock.add(new SoapBehavior());
        HPItemActionOnBlock.add(new WrenchBehavior());
        HPItemActionOnBlock.add(new SkullCandlesBehavior());
        itemActionOnBlock.add(new SkullPileBehavior());
        itemActionOnBlock.add(new EnhancedCakeBehavior());
        itemActionOnBlock.add(new MapMarkerBehavior());
        itemActionOnBlock.add(new XpBottlingBehavior());
        if (CommonConfigs.Tweaks.WRITTEN_BOOKS.get().booleanValue()) {
            ((IExtendedItem)Items.f_42614_).addAdditionalBehavior(new SimplePlacement(ModRegistry.BOOK_PILE.get()));
            ((IExtendedItem)Items.f_42615_).addAdditionalBehavior(new SimplePlacement(ModRegistry.BOOK_PILE.get()));
        }
        block0: for (Item i : Registry.f_122827_) {
            BlockItem bi;
            if (CommonConfigs.Tweaks.WALL_LANTERN_PLACEMENT.get().booleanValue() && i instanceof BlockItem && MiscUtils.isLanternBlock((bi = (BlockItem)i).m_40614_())) {
                ((IExtendedItem)i).addAdditionalBehavior(new WallLanternPlacement());
                continue;
            }
            if (CommonConfigs.Tweaks.PLACEABLE_BOOKS.get().booleanValue() && BookPileBlock.isQuarkTome(i)) {
                ((IExtendedItem)i).addAdditionalBehavior(new SimplePlacement(ModRegistry.BOOK_PILE.get()));
                continue;
            }
            for (ItemUseOnBlockOverride itemUseOnBlockOverride : itemActionOnBlock) {
                if (!itemUseOnBlockOverride.appliesToItem(i)) continue;
                ON_BLOCK_OVERRIDES.put(i, itemUseOnBlockOverride);
                continue block0;
            }
            for (ItemUseOverride itemUseOverride : itemAction) {
                if (!itemUseOverride.appliesToItem(i)) continue;
                ITEM_USE_OVERRIDES.put(i, itemUseOverride);
                continue block0;
            }
            for (ItemUseOnBlockOverride itemUseOnBlockOverride : HPItemActionOnBlock) {
                if (!itemUseOnBlockOverride.appliesToItem(i)) continue;
                HP_ON_BLOCK_OVERRIDES.put(i, itemUseOnBlockOverride);
                continue block0;
            }
        }
        block4: for (Block block : Registry.f_122824_) {
            for (BlockInteractedWithOverride blockInteractedWithOverride : actionOnBlock) {
                if (!blockInteractedWithOverride.appliesToBlock(block)) continue;
                BLOCK_USE_OVERRIDES.put(block, blockInteractedWithOverride);
                continue block4;
            }
        }
    }

    public static InteractionResult tryHighPriorityClickedBlockOverride(Player player, Level level, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        ItemUseOnBlockOverride override = HP_ON_BLOCK_OVERRIDES.get(item);
        if (override != null && override.isEnabled()) {
            return override.tryPerformingAction(level, player, hand, stack, hit, false);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult tryPerformClickedBlockOverride(Player player, Level level, InteractionHand hand, BlockHitResult hit, boolean isRanged) {
        return ItemsOverrideHandler.tryPerformClickedBlockOverride(player, level, player.m_21120_(hand), hand, hit, isRanged);
    }

    public static InteractionResult tryPerformClickedBlockOverride(Player player, Level level, ItemStack stack, InteractionHand hand, BlockHitResult hit, boolean isRanged) {
        BlockPos pos;
        BlockState state;
        BlockInteractedWithOverride o;
        InteractionResult result;
        Item item = stack.m_41720_();
        ItemUseOnBlockOverride override = ON_BLOCK_OVERRIDES.get(item);
        if (override != null && override.isEnabled() && (result = override.tryPerformingAction(level, player, hand, stack, hit, isRanged)) != InteractionResult.PASS) {
            return result;
        }
        if (!player.m_6144_() && (o = BLOCK_USE_OVERRIDES.get((state = level.m_8055_(pos = hit.m_82425_())).m_60734_())) != null && o.isEnabled()) {
            return o.tryPerformingAction(state, pos, level, player, hand, stack, hit);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> tryPerformClickedItemOverride(Player player, Level level, InteractionHand hand, ItemStack stack) {
        Item item = stack.m_41720_();
        ItemUseOverride override = ITEM_USE_OVERRIDES.get(item);
        if (override != null && override.isEnabled()) {
            InteractionResult ret = override.tryPerformingAction(level, player, hand, stack, null, false);
            return switch (ret) {
                case InteractionResult.CONSUME -> InteractionResultHolder.m_19096_((Object)stack);
                case InteractionResult.SUCCESS -> InteractionResultHolder.m_19090_((Object)stack);
                default -> InteractionResultHolder.m_19098_((Object)stack);
                case InteractionResult.FAIL -> InteractionResultHolder.m_19100_((Object)stack);
            };
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static void addOverrideTooltips(ItemStack itemStack, TooltipFlag tooltipFlag, List<Component> components) {
        Item item = itemStack.m_41720_();
        ItemUseOnBlockOverride override = ON_BLOCK_OVERRIDES.get(item);
        if (override != null && override.isEnabled()) {
            MutableComponent t = override.getTooltip();
            if (t != null) {
                components.add((Component)t.m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
            }
        } else {
            MutableComponent t;
            ItemUseOverride o = ITEM_USE_OVERRIDES.get(item);
            if (o != null && o.isEnabled() && (t = o.getTooltip()) != null) {
                components.add((Component)t.m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
            }
        }
    }

    public static InteractionResult replaceSimilarBlock(Block blockOverride, Player player, ItemStack stack, BlockPos pos, Level level, BlockState replaced, @Nullable SoundType sound, Property<?> ... properties) {
        BlockState newState = blockOverride.m_49966_();
        for (Property<?> p : properties) {
            newState = BlockUtil.replaceProperty(replaced, newState, p);
        }
        if (newState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            FluidState fluidstate = level.m_6425_(pos);
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8));
        }
        if (!level.m_7731_(pos, newState, 3)) {
            return InteractionResult.FAIL;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10591_.m_59469_(serverPlayer, pos, stack);
        }
        level.m_142346_((Entity)player, GameEvent.f_157797_, pos);
        if (sound == null) {
            sound = newState.m_60827_();
        }
        level.m_5594_(player, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        if (player == null || !player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static abstract class ItemUseOnBlockOverride
    extends ItemUseOverride {
        private ItemUseOnBlockOverride() {
        }

        public boolean shouldBlockMapToItem(Item item) {
            return this.appliesToItem(item);
        }

        @Override
        @Nullable
        public MutableComponent getTooltip() {
            return null;
        }
    }

    private static class DirectionalCakeConversionBehavior
    extends BlockInteractedWithOverride {
        private DirectionalCakeConversionBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return CommonConfigs.Tweaks.DIRECTIONAL_CAKE.get();
        }

        @Override
        public boolean appliesToBlock(Block block) {
            return block == Blocks.f_50145_ || block.m_204297_().m_203656_(BlockTags.f_144268_) && Utils.getID((Block)block).m_135827_().equals("minecraft");
        }

        @Override
        public InteractionResult tryPerformingAction(BlockState state, BlockPos pos, Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
            if (state.m_204336_(BlockTags.f_144268_) && stack.m_204117_(ItemTags.f_144319_)) {
                return InteractionResult.PASS;
            }
            if (state.m_60713_(Blocks.f_50145_) && (stack.m_204117_(ItemTags.f_144319_) || player.m_6350_() == Direction.EAST || (Integer)state.m_61143_((Property)CakeBlock.f_51180_) != 0)) {
                return InteractionResult.PASS;
            }
            if (!CommonConfigs.Tweaks.DOUBLE_CAKE_PLACEMENT.get().booleanValue() || !stack.m_150930_(Items.f_42502_)) {
                BlockState newState = ModRegistry.DIRECTIONAL_CAKE.get().m_49966_();
                if (world.f_46443_) {
                    world.m_7731_(pos, newState, 3);
                }
                BlockHitResult raytrace = new BlockHitResult(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), hit.m_82434_(), pos, false);
                InteractionResult r = newState.m_60664_(world, player, hand, raytrace);
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    if (r.m_19077_()) {
                        Block.m_49869_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null).forEach(d -> {
                            if (d.m_41720_() != Items.f_42502_) {
                                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)d);
                            }
                        });
                        state.m_222967_(serverLevel, pos, ItemStack.f_41583_, true);
                    } else {
                        world.m_7731_(pos, state, 3);
                    }
                }
                return r;
            }
            return InteractionResult.PASS;
        }
    }

    private static class BellChainBehavior
    extends BlockInteractedWithOverride {
        private BellChainBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return CommonConfigs.Tweaks.BELL_CHAIN.get();
        }

        @Override
        public boolean appliesToBlock(Block block) {
            return block instanceof ChainBlock;
        }

        @Override
        public InteractionResult tryPerformingAction(BlockState state, BlockPos pos, Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
            if (stack.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                if (RopeBlock.findAndRingBell(world, pos, player, 0, s -> s.m_60734_() instanceof ChainBlock && s.m_61143_((Property)ChainBlock.f_55923_) == Direction.Axis.Y)) {
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.PASS;
        }
    }

    private static class FDStickBehavior
    extends BlockInteractedWithOverride {
        private FDStickBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return CommonConfigs.Tweaks.PLACEABLE_STICKS.get() != false && CompatHandler.FARMERS_DELIGHT;
        }

        @Override
        public boolean appliesToBlock(Block block) {
            return block == CompatObjects.TOMATOES.get();
        }

        @Override
        public InteractionResult tryPerformingAction(BlockState state, BlockPos pos, Level level, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
            Block tomato;
            if (stack.m_41720_() == Items.f_42398_ && (tomato = FarmersDelightCompat.getStickTomato()) != null) {
                return ItemsOverrideHandler.replaceSimilarBlock(tomato, player, stack, pos, level, state, SoundType.f_56736_, new Property[]{BlockStateProperties.f_61407_});
            }
            return InteractionResult.PASS;
        }
    }

    private static class ThrowableBrickBehavior
    extends ItemUseOverride {
        private ThrowableBrickBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return CommonConfigs.Tweaks.THROWABLE_BRICKS_ENABLED.get();
        }

        @Override
        @Nullable
        public MutableComponent getTooltip() {
            return Component.m_237115_((String)"message.supplementaries.throwable_brick");
        }

        @Override
        public boolean appliesToItem(Item item) {
            return item.m_204114_().m_203656_(ModTags.BRICKS);
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.m_217043_().m_188501_() * 0.4f + 0.8f));
            if (!world.f_46443_) {
                ThrowableBrickEntity brickEntity = new ThrowableBrickEntity(world, (LivingEntity)player);
                brickEntity.m_37446_(stack);
                float pow = 0.7f;
                brickEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f * pow, 1.0f * pow);
                world.m_7967_((Entity)brickEntity);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
    }

    private static class ClockItemBehavior
    extends ItemUseOverride {
        private ClockItemBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return ClientConfigs.Tweaks.CLOCK_CLICK.get();
        }

        @Override
        public boolean appliesToItem(Item item) {
            return item == Items.f_42524_;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (world.f_46443_) {
                ClockBlock.displayCurrentHour(world, player);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
    }

    private static class CompassItemBehavior
    extends ItemUseOverride {
        private CompassItemBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return ClientConfigs.Tweaks.COMPASS_CLICK.get();
        }

        @Override
        public boolean appliesToItem(Item item) {
            return item == Items.f_42522_;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (world.f_46443_) {
                GlobeBlock.displayCurrentCoordinates(world, player, player.m_20183_());
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
    }

    private static class AntiqueInkBehavior
    extends ItemUseOnBlockOverride {
        private AntiqueInkBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return AntiqueInkHelper.isEnabled();
        }

        @Override
        public boolean appliesToItem(Item item) {
            return item == Items.f_42532_ || item == ModRegistry.ANTIQUE_INK.get();
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (player.m_150110_().f_35938_) {
                IOwnerProtected op;
                boolean newState = !stack.m_150930_(Items.f_42532_);
                BlockPos pos = hit.m_82425_();
                BlockEntity tile = world.m_7702_(pos);
                if (tile != null && (!(tile instanceof IOwnerProtected) || (op = (IOwnerProtected)tile).isAccessibleBy(player)) && AntiqueInkHelper.toggleAntiqueInkOnSigns(world, player, stack, newState, pos, tile)) {
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
            }
            return InteractionResult.PASS;
        }
    }

    private static class SoapBehavior
    extends ItemUseOnBlockOverride {
        private SoapBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return RegistryConfigs.SOAP_ENABLED.get();
        }

        @Override
        public boolean appliesToItem(Item item) {
            return item == ModRegistry.SOAP.get();
        }

        @Override
        public InteractionResult tryPerformingAction(Level level, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            BlockPos pos;
            if (player.m_150110_().f_35938_ && SoapWashableHelper.tryWash(level, pos = hit.m_82425_(), level.m_8055_(pos))) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                    level.m_5594_(null, pos, SoundEvents.f_144178_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    CriteriaTriggers.f_10562_.m_220040_(serverPlayer, pos, stack);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }
    }

    private static class WrenchBehavior
    extends ItemUseOnBlockOverride {
        private WrenchBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return RegistryConfigs.WRENCH_ENABLED.get();
        }

        @Override
        public boolean appliesToItem(Item item) {
            return item == ModRegistry.WRENCH.get();
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            CommonConfigs.Hands h;
            if (player.m_150110_().f_35938_ && ((h = CommonConfigs.Items.WRENCH_BYPASS.get()) == CommonConfigs.Hands.MAIN_HAND && hand == InteractionHand.MAIN_HAND || h == CommonConfigs.Hands.OFF_HAND && hand == InteractionHand.OFF_HAND || h == CommonConfigs.Hands.BOTH)) {
                return stack.m_41661_(new UseOnContext(player, hand, hit));
            }
            return InteractionResult.PASS;
        }
    }

    private static class SkullCandlesBehavior
    extends ItemUseOnBlockOverride {
        private SkullCandlesBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return CommonConfigs.Tweaks.SKULL_CANDLES.get();
        }

        @Override
        public boolean appliesToItem(Item item) {
            if (item.m_204114_().m_203656_(ItemTags.f_144319_)) {
                String n = Utils.getID((Item)item).m_135827_();
                return n.equals("minecraft") || n.equals("tinted") || item == CompatObjects.SOUL_CANDLE_ITEM.get();
            }
            return false;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            SkullBlock skullBlock;
            SkullBlockEntity oldTile;
            BlockState state;
            Block block;
            BlockPos pos;
            BlockEntity blockEntity;
            if (player.m_150110_().f_35938_ && (blockEntity = world.m_7702_(pos = hit.m_82425_())) instanceof SkullBlockEntity && (block = (state = (oldTile = (SkullBlockEntity)blockEntity).m_58900_()).m_60734_()) instanceof SkullBlock && (skullBlock = (SkullBlock)block).m_48754_() != SkullBlock.Types.DRAGON) {
                BlockEntity blockEntity2;
                ItemStack copy = stack.m_41777_();
                Block b = CompatHandler.BUZZIER_BEES && stack.m_41720_() == CompatObjects.SOUL_CANDLE_ITEM.get() ? ModRegistry.SKULL_CANDLE_SOUL.get() : ModRegistry.SKULL_CANDLE.get();
                InteractionResult result = ItemsOverrideHandler.replaceSimilarBlock(b, player, stack, pos, world, state, SoundType.f_154653_, new Property[]{SkullBlock.f_56314_});
                if (result.m_19077_() && (blockEntity2 = world.m_7702_(pos)) instanceof CandleSkullBlockTile) {
                    CandleSkullBlockTile tile = (CandleSkullBlockTile)blockEntity2;
                    tile.initialize(oldTile, skullBlock, copy, player, hand);
                }
                return result;
            }
            return InteractionResult.PASS;
        }
    }

    private static class SkullPileBehavior
    extends ItemUseOnBlockOverride {
        private SkullPileBehavior() {
        }

        @Override
        @Nullable
        public MutableComponent getTooltip() {
            return Component.m_237115_((String)"message.supplementaries.double_cake");
        }

        @Override
        public boolean isEnabled() {
            return CommonConfigs.Tweaks.SKULL_PILES.get();
        }

        @Override
        public boolean appliesToItem(Item item) {
            SkullBlock skull;
            BlockItem bi;
            Block block;
            return item instanceof BlockItem && (block = (bi = (BlockItem)item).m_40614_()) instanceof SkullBlock && (skull = (SkullBlock)block).m_48754_() != SkullBlock.Types.DRAGON && skull.m_48754_() != EndermanSkullBlock.TYPE;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            SkullBlock skullBlock;
            SkullBlockEntity oldTile;
            BlockState state;
            Block block;
            BlockPos pos;
            BlockEntity blockEntity;
            if (player.m_150110_().f_35938_ && (blockEntity = world.m_7702_(pos = hit.m_82425_())) instanceof SkullBlockEntity && (block = (state = (oldTile = (SkullBlockEntity)blockEntity).m_58900_()).m_60734_()) instanceof SkullBlock && (skullBlock = (SkullBlock)block).m_48754_() != SkullBlock.Types.DRAGON) {
                BlockEntity blockEntity2;
                ItemStack copy = stack.m_41777_();
                InteractionResult result = ItemsOverrideHandler.replaceSimilarBlock(ModRegistry.SKULL_PILE.get(), player, stack, pos, world, state, null, new Property[]{SkullBlock.f_56314_});
                if (result.m_19077_() && (blockEntity2 = world.m_7702_(pos)) instanceof DoubleSkullBlockTile) {
                    DoubleSkullBlockTile tile = (DoubleSkullBlockTile)blockEntity2;
                    tile.initialize(oldTile, skullBlock, copy, player, hand);
                }
                return result;
            }
            return InteractionResult.PASS;
        }
    }

    private static class EnhancedCakeBehavior
    extends ItemUseOnBlockOverride {
        private EnhancedCakeBehavior() {
        }

        @Override
        @Nullable
        public MutableComponent getTooltip() {
            return Component.m_237115_((String)"message.supplementaries.double_cake");
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean appliesToItem(Item item) {
            return item == Items.f_42502_;
        }

        private InteractionResult placeDoubleCake(Player player, ItemStack stack, BlockPos pos, Level world, BlockState state, boolean isRanged) {
            boolean isDirectional;
            boolean bl = isDirectional = state.m_60734_() == ModRegistry.DIRECTIONAL_CAKE.get();
            if (isDirectional && (Integer)state.m_61143_((Property)DirectionalCakeBlock.f_51180_) == 0 || state == Blocks.f_50145_.m_49966_()) {
                return ItemsOverrideHandler.replaceSimilarBlock(ModRegistry.DOUBLE_CAKE.get(), player, stack, pos, world, state, null, new Property[]{DoubleCakeBlock.FACING});
            }
            return InteractionResult.PASS;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            BlockPos pos;
            BlockState state;
            Block b;
            if (player.m_150110_().f_35938_ && ((b = (state = world.m_8055_(pos = hit.m_82425_())).m_60734_()) == Blocks.f_50145_ || b == ModRegistry.DIRECTIONAL_CAKE.get())) {
                InteractionResult result = InteractionResult.FAIL;
                if (CommonConfigs.Tweaks.DOUBLE_CAKE_PLACEMENT.get().booleanValue()) {
                    result = this.placeDoubleCake(player, stack, pos, world, state, isRanged);
                }
                return result;
            }
            return InteractionResult.PASS;
        }
    }

    private static class MapMarkerBehavior
    extends ItemUseOnBlockOverride {
        private MapMarkerBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return CommonConfigs.Tweaks.MAP_MARKERS.get();
        }

        @Override
        public boolean appliesToItem(Item item) {
            return item instanceof MapItem || CompatHandler.MAPATLAS && MapAtlasCompat.isAtlas((Item)item);
        }

        @Override
        public InteractionResult tryPerformingAction(Level level, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            BlockPos pos = hit.m_82425_();
            if (MapHelper.toggleMarkersAtPos((Level)level, (BlockPos)pos, (ItemStack)stack, (Player)player)) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }
    }

    private static class XpBottlingBehavior
    extends ItemUseOnBlockOverride {
        private XpBottlingBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return CommonConfigs.Tweaks.BOTTLE_XP.get();
        }

        @Override
        public boolean appliesToItem(Item item) {
            return item == Items.f_42590_ || item instanceof JarItem || item == Items.f_42612_;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            JarBlockTile dummyTile = new JarBlockTile(BlockPos.f_121853_, ModRegistry.JAR.get().m_49966_());
            BlockPos pos = hit.m_82425_();
            Item i = stack.m_41720_();
            if (world.m_8055_(pos).m_60734_() instanceof EnchantmentTableBlock) {
                ItemStack returnStack = null;
                if (i == Items.f_42612_) {
                    return InteractionResult.FAIL;
                }
                if (player.f_36078_ > 0 || player.m_7500_()) {
                    if (i == Items.f_42590_) {
                        returnStack = new ItemStack((ItemLike)Items.f_42612_);
                    } else if (i instanceof JarItem) {
                        ItemStack tempStack;
                        ItemStack temp;
                        dummyTile.resetHolders();
                        CompoundTag tag = stack.m_41737_("BlockEntityTag");
                        if (tag != null) {
                            dummyTile.m_142466_(tag);
                        }
                        if (dummyTile.canInteractWithSoftFluidTank() && (temp = dummyTile.fluidHolder.interactWithItem(tempStack = new ItemStack((ItemLike)Items.f_42612_), null, null, false)) != null && temp.m_41720_() == Items.f_42590_) {
                            returnStack = ((JarBlock)((BlockItem)i).m_40614_()).getJarItem(dummyTile);
                        }
                    }
                    if (returnStack != null) {
                        player.m_6469_(ModDamageSources.BOTTLING_DAMAGE, (float)CommonConfigs.Tweaks.BOTTLING_COST.get().intValue());
                        Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)returnStack);
                        if (!player.m_7500_()) {
                            player.m_6756_(-Utils.getXPinaBottle((int)1, (RandomSource)world.f_46441_) - 3);
                        }
                        if (world.f_46443_) {
                            Minecraft.m_91087_().f_91061_.m_107332_((Entity)player, (ParticleOptions)ModParticles.BOTTLING_XP_PARTICLE.get(), 1);
                        }
                        world.m_5594_(null, player.m_20183_(), SoundEvents.f_11771_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResult.m_19078_((boolean)world.f_46443_);
                    }
                }
            }
            return InteractionResult.PASS;
        }
    }

    private static abstract class ItemUseOverride {
        private ItemUseOverride() {
        }

        public abstract boolean isEnabled();

        public abstract boolean appliesToItem(Item var1);

        @Nullable
        public MutableComponent getTooltip() {
            return null;
        }

        public abstract InteractionResult tryPerformingAction(Level var1, Player var2, InteractionHand var3, ItemStack var4, BlockHitResult var5, boolean var6);
    }

    private static abstract class BlockInteractedWithOverride {
        private BlockInteractedWithOverride() {
        }

        public abstract boolean isEnabled();

        public abstract boolean appliesToBlock(Block var1);

        public abstract InteractionResult tryPerformingAction(BlockState var1, BlockPos var2, Level var3, Player var4, InteractionHand var5, ItemStack var6, BlockHitResult var7);
    }
}

