/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events;

import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.IFireConsumeBlockEvent;
import net.mehvahdjukaar.moonlight.api.misc.EventCalled;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AshLayerBlock;
import net.mehvahdjukaar.supplementaries.common.entities.goals.EatFodderGoal;
import net.mehvahdjukaar.supplementaries.common.entities.goals.EvokerRedMerchantWololooSpellGoal;
import net.mehvahdjukaar.supplementaries.common.events.ItemsOverrideHandler;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.FluteItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.CapturedMobHandler;
import net.mehvahdjukaar.supplementaries.common.world.data.GlobeData;
import net.mehvahdjukaar.supplementaries.common.world.songs.SongsManager;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.mixins.accessors.MobAccessor;
import net.mehvahdjukaar.supplementaries.reg.LootTablesInjects;
import net.mehvahdjukaar.supplementaries.reg.ModSetup;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class ServerEvents {
    private static final boolean FODDER_ENABLED = RegistryConfigs.FODDER_ENABLED.get();

    @EventCalled
    public static void onFireConsume(IFireConsumeBlockEvent event) {
        if (event.getState().m_60734_() instanceof IRopeConnection) {
            LevelAccessor level = event.getLevel();
            BlockPos pos = event.getPos();
            level.m_7471_(pos, false);
            if (BaseFireBlock.m_49255_((Level)((Level)level), (BlockPos)pos, (Direction)Direction.DOWN)) {
                event.setFinalState((BlockState)BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos).m_61124_((Property)FireBlock.f_53408_, (Comparable)Integer.valueOf(8)));
                level.m_186460_(pos, Blocks.f_50083_, 2 + ((Level)level).f_46441_.m_188503_(1));
            }
        } else {
            AshLayerBlock.tryConvertToAsh(event);
        }
    }

    @EventCalled
    public static InteractionResult onRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.m_5833_()) {
            return ItemsOverrideHandler.tryPerformClickedBlockOverride(player, level, hand, hitResult, false);
        }
        return InteractionResult.PASS;
    }

    @EventCalled
    public static InteractionResult onRightClickBlockHP(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.m_5833_()) {
            return ItemsOverrideHandler.tryHighPriorityClickedBlockOverride(player, level, hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    @EventCalled
    public static InteractionResultHolder<ItemStack> onUseItem(Player player, Level level, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_5833_()) {
            return ItemsOverrideHandler.tryPerformClickedItemOverride(player, level, hand, stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @EventCalled
    public static void onPlayerLoggedIn(ServerPlayer player) {
    }

    @EventCalled
    public static InteractionResult onRightClickEntity(Player player, Level level, InteractionHand hand, Entity entity, @Nullable EntityHitResult entityHitResult) {
        InteractionResult res;
        AbstractMobContainerItem containerItem;
        Item item;
        if (player.m_5833_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof FluteItem ? FluteItem.interactWithPet(stack, player, entity, hand) : (item = stack.m_41720_()) instanceof AbstractMobContainerItem && !(containerItem = (AbstractMobContainerItem)item).isFull(stack) && (res = containerItem.doInteract(stack, player, entity, hand)).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @EventCalled
    public static void onDataSyncToPlayer(ServerPlayer player, boolean joined) {
        SongsManager.sendSongsToClient(player);
        CapturedMobHandler.sendDataToClient(player);
        GlobeData.sendDataToClient(player);
    }

    @EventCalled
    public static void onCommonTagUpdate(RegistryAccess registryAccess, boolean client) {
        ModSetup.tagDependantSetup();
    }

    @EventCalled
    public static void onEntityLoad(Entity entity, ServerLevel serverLevel) {
        if (FODDER_ENABLED && entity instanceof Animal) {
            Animal animal = (Animal)entity;
            EntityType type = entity.m_6095_();
            if (type.m_204039_(ModTags.EATS_FODDER)) {
                ((MobAccessor)animal).getGoalSelector().m_25352_(3, (Goal)new EatFodderGoal(animal, 1.0, 8, 2, 30));
            }
            return;
        }
        if (entity.m_6095_() == EntityType.f_20568_) {
            ((MobAccessor)entity).getGoalSelector().m_25352_(6, (Goal)new EvokerRedMerchantWololooSpellGoal((Evoker)entity));
        }
    }

    @EventCalled
    public static void injectLootTables(LootTables lootManager, ResourceLocation name, Consumer<LootPool.Builder> builder) {
        LootTablesInjects.injectLootTables(name, builder);
    }
}

