/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.Registry;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class RandomArrowFunction
extends LootItemConditionalFunction {
    private static final List<ItemStack> RANDOM_ARROWS = new ArrayList<ItemStack>();
    final int min;
    final int max;

    public static void setup() {
        for (Potion potion : Registry.f_122828_) {
            boolean isNegative = false;
            for (MobEffectInstance e : potion.m_43488_()) {
                if (e.m_19544_().m_19486_()) continue;
                isNegative = true;
                break;
            }
            if (!isNegative) continue;
            RANDOM_ARROWS.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)potion));
        }
        RANDOM_ARROWS.add(new ItemStack((ItemLike)Items.f_42737_));
    }

    RandomArrowFunction(LootItemCondition[] pConditions, int min, int max) {
        super(pConditions);
        this.min = min;
        this.max = max;
    }

    public LootItemFunctionType m_7162_() {
        return ModRegistry.RANDOM_ARROW_FUNCTION.get();
    }

    public ItemStack m_7372_(ItemStack pStack, LootContext pContext) {
        RandomSource random = pContext.m_230907_();
        RandomArrowFunction.createRandomQuiver(random, pStack, random.m_216339_(this.min, this.max + 1));
        return pStack;
    }

    public static ItemStack createRandomQuiver(RandomSource random, float specialMultiplier) {
        ItemStack quiver = new ItemStack((ItemLike)ModRegistry.QUIVER_ITEM.get());
        int amount = random.m_216339_(3, (int)(8.0f + specialMultiplier * 4.0f));
        return RandomArrowFunction.createRandomQuiver(random, quiver, amount);
    }

    private static ItemStack createRandomQuiver(RandomSource random, ItemStack quiver, int amount) {
        int stackAmount;
        QuiverItem.IQuiverData data = QuiverItem.getQuiverData(quiver);
        if (data == null) {
            return quiver;
        }
        for (int tries = 0; amount > 0 && tries < 10; amount -= stackAmount, ++tries) {
            stackAmount = random.m_216339_(1, 7);
            ItemStack arrow = RANDOM_ARROWS.get(random.m_188503_(RANDOM_ARROWS.size())).m_41777_();
            stackAmount = Math.min(amount, stackAmount);
            arrow.m_41764_(stackAmount);
            data.tryAdding(arrow);
        }
        return quiver;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomArrowFunction> {
        public void serialize(JsonObject jsonObject, RandomArrowFunction function, JsonSerializationContext context) {
            super.m_6170_(jsonObject, (LootItemConditionalFunction)function, context);
            jsonObject.addProperty("min", (Number)function.min);
            jsonObject.addProperty("max", (Number)function.max);
        }

        public RandomArrowFunction deserialize(JsonObject pObject, JsonDeserializationContext context, LootItemCondition[] pConditions) {
            int min = GsonHelper.m_13824_((JsonObject)pObject, (String)"min", (int)3);
            int max = GsonHelper.m_13824_((JsonObject)pObject, (String)"max", (int)12);
            return new RandomArrowFunction(pConditions, min, max);
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final int min;
        private final int max;

        public Builder() {
            this(3, 12);
        }

        public Builder(int min, int max) {
            this.min = min;
            this.max = max;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new RandomArrowFunction(this.m_80699_(), this.min, this.max);
        }
    }
}

