/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.world.songs.Song;
import net.mehvahdjukaar.supplementaries.common.world.songs.SongsManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;

public class ClientBoundSyncSongsPacket
implements Message {
    protected final List<Song> songs;

    public ClientBoundSyncSongsPacket(Collection<Song> songs) {
        this.songs = List.copyOf(songs);
    }

    public ClientBoundSyncSongsPacket(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.songs = new ArrayList<Song>();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = buf.m_130260_();
            if (tag == null) continue;
            DataResult r = Song.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
            r.result().ifPresent(this.songs::add);
        }
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeInt(this.songs.size());
        for (Song entry : this.songs) {
            DataResult r = Song.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry);
            if (!r.result().isPresent()) continue;
            buf.m_130079_((CompoundTag)r.result().get());
        }
    }

    public void handle(ChannelHandler.Context context) {
        SongsManager.acceptClientSongs(this.songs);
        Supplementaries.LOGGER.info("Synced Flute Songs");
    }
}

