/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.forge;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.PermissionRegistry;
import io.github.flemmli97.flan.claim.ClaimStorage;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public final class FlanCompatImpl {
    public static boolean canBreak(@Nonnull Player player, @Nonnull BlockPos pos) {
        if (player.f_19853_.f_46443_) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.f_19853_));
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            return claim.canInteract((ServerPlayer)player, PermissionRegistry.BREAK, pos, true);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.error("Failed call break block event: [Player: {}, Pos: {}]", (Object)player, (Object)pos, (Object)e);
            return true;
        }
    }

    public static boolean canPlace(@Nonnull Player player, @Nonnull BlockPos pos, @Nonnull BlockState blockState) {
        if (player.f_19853_.f_46443_) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.f_19853_));
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            return claim.canInteract((ServerPlayer)player, PermissionRegistry.PLACE, pos);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.error("Failed call place block event: [Player: {}, Pos: {}, Block State: {}]", (Object)player, (Object)pos, (Object)blockState, (Object)e);
            return true;
        }
    }

    public static boolean canReplace(@Nonnull Player player, @Nonnull BlockPos pos, @Nonnull BlockState blockState) {
        if (player.f_19853_.f_46443_) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.f_19853_));
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            return claim.canInteract((ServerPlayer)player, PermissionRegistry.PLACE, pos);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.error("Failed call replace block event: [Player: {}, Pos: {}, Block State: {}]", (Object)player, (Object)pos, (Object)blockState, (Object)e);
            return true;
        }
    }

    public static boolean canAttack(@Nonnull Player player, @Nonnull Entity victim) {
        if (player.f_19853_.f_46443_) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.f_19853_));
            IPermissionContainer claim = storage.getForPermissionCheck(victim.m_20183_());
            return claim.canInteract((ServerPlayer)player, PermissionRegistry.HURTANIMAL, victim.m_20183_());
        }
        catch (Exception e) {
            Supplementaries.LOGGER.error("Failed call attack entity event: [Player: {}, Victim: {}]", (Object)player, (Object)victim, (Object)e);
            return true;
        }
    }

    public static boolean canInteract(@Nonnull Player player, @Nonnull HumanoidArm hand, @Nonnull BlockPos targetPos, @Nonnull Direction targetSide) {
        if (player.f_19853_.f_46443_) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.f_19853_));
            IPermissionContainer claim = storage.getForPermissionCheck(targetPos);
            return claim.canInteract((ServerPlayer)player, PermissionRegistry.INTERACTBLOCK, targetPos);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.error("Failed call interact event: [Player: {}, Hand: {}, Pos: {}, Side: {}]", (Object)player, (Object)hand, (Object)targetPos, (Object)targetSide, (Object)e);
            return true;
        }
    }

    public static boolean canInteract(@Nonnull Player player, @Nonnull HumanoidArm hand, @Nonnull BlockPos interactionPos, @Nonnull BlockPos targetPos, @Nonnull Direction targetSide) {
        if (player.f_19853_.f_46443_) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.f_19853_));
            IPermissionContainer claim = storage.getForPermissionCheck(targetPos);
            return claim.canInteract((ServerPlayer)player, PermissionRegistry.INTERACTBLOCK, targetPos);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.error("Failed call interact event: [Player: {}, Hand: {}, Pos: {}, Side: {}]", (Object)player, (Object)hand, (Object)targetPos, (Object)targetSide, (Object)e);
            return true;
        }
    }
}

