/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import net.mehvahdjukaar.supplementaries.common.entities.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Stray.class})
public abstract class StrayMixin
extends AbstractSkeleton
implements IQuiverEntity {
    @Unique
    private ItemStack quiver = ItemStack.f_41583_;
    @Unique
    private float quiverDropChance = 0.6f;
    private static final EntityDataAccessor<Boolean> HAS_QUIVER = SynchedEntityData.m_135353_(Stray.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected StrayMixin(EntityType<? extends AbstractSkeleton> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(HAS_QUIVER, (Object)false);
    }

    protected void m_7472_(DamageSource damageSource, int looting, boolean hitByPlayer) {
        super.m_7472_(damageSource, looting, hitByPlayer);
        if (this.quiver != null && hitByPlayer) {
            ItemStack itemStack = this.quiver;
            if (Math.max(this.f_19796_.m_188501_() - (float)looting * 0.02f, 0.0f) < this.quiverDropChance) {
                this.m_19983_(itemStack);
                this.quiver = ItemStack.f_41583_;
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (!this.quiver.m_41619_()) {
            compound.m_128365_("Quiver", (Tag)this.quiver.m_41739_(new CompoundTag()));
            compound.m_128350_("QuiverDropChance", this.quiverDropChance);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Quiver")) {
            this.setQuiver(ItemStack.m_41712_((CompoundTag)compound.m_128469_("Quiver")));
            this.quiverDropChance = compound.m_128457_("QuiverDropChance");
        }
    }

    @Override
    public ItemStack getQuiver() {
        return this.quiver;
    }

    @Override
    public boolean hasQuiver() {
        if (this.f_19853_ != null && this.f_19853_.f_46443_) {
            return (Boolean)this.m_20088_().m_135370_(HAS_QUIVER);
        }
        return IQuiverEntity.super.hasQuiver();
    }

    @Override
    public void setQuiver(ItemStack quiver) {
        this.quiver = quiver;
        this.m_20088_().m_135381_(HAS_QUIVER, (Object)(!quiver.m_41619_() ? 1 : 0));
    }

    public boolean m_7243_(ItemStack stack) {
        if (this.quiver == null && stack.m_41720_() == ModRegistry.QUIVER_ITEM.get()) {
            return true;
        }
        return super.m_7243_(stack);
    }

    public boolean m_21540_(ItemStack stack) {
        if (stack.m_41720_() == ModRegistry.QUIVER_ITEM.get()) {
            if (this.quiver != null) {
                this.m_19983_(this.quiver);
            }
            this.setQuiver(stack);
            this.quiverDropChance = 1.0f;
            return true;
        }
        return super.m_21540_(stack);
    }
}

