/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import javax.annotation.Nonnull;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.VanillaSoftFluids;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PancakeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.entities.PearlMarker;
import net.mehvahdjukaar.supplementaries.common.entities.RopeArrowEntity;
import net.mehvahdjukaar.supplementaries.common.entities.ThrowableBrickEntity;
import net.mehvahdjukaar.supplementaries.common.items.BombItem;
import net.mehvahdjukaar.supplementaries.common.items.DispenserMinecartItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class DispenserInteractionsRegistry {
    public static void registerBehaviors() {
        boolean isForge = PlatformHelper.getPlatform().isForge();
        if (!RegistryConfigs.DISPENSERS.get().booleanValue()) {
            return;
        }
        if (RegistryConfigs.PANCAKES_ENABLED.get().booleanValue() && CompatHandler.QUARK && QuarkCompat.isJukeboxModuleOn()) {
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.PANCAKE.get()), (DispenseItemBehavior)new PancakeDiscBehavior());
        }
        if (CommonConfigs.Tweaks.ENDER_PEAR_DISPENSERS.get().booleanValue()) {
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new EnderPearlBehavior());
        }
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.DISPENSER_MINECART_ITEM.get()), (DispenseItemBehavior)DispenserMinecartItem.DISPENSE_ITEM_BEHAVIOR);
        OptionalDispenseItemBehavior armorBehavior = new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                this.m_123573_(ArmorItem.m_40398_((BlockSource)source, (ItemStack)stack));
                return stack;
            }
        };
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.ENDERMAN_SKULL_ITEM.get()), (DispenseItemBehavior)armorBehavior);
        DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.FODDER.get()));
        DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.BUBBLE_BLOCK.get()));
        DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.SACK.get()));
        DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.JAR_ITEM.get()));
        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new DispenserHelper.AddItemToInventoryBehavior(Items.f_42572_));
        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FlintAndSteelDispenserBehavior(Items.f_42409_));
        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new BambooSpikesDispenserBehavior(Items.f_42739_));
        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new PancakesDispenserBehavior(Items.f_42787_));
        if (isForge) {
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FakePlayerUseItemBehavior(ModRegistry.SOAP.get()));
        }
        if (CommonConfigs.Tweaks.THROWABLE_BRICKS_ENABLED.get().booleanValue()) {
            Registry.f_122827_.m_206058_(ModTags.BRICKS).iterator().forEachRemaining(h -> DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new ThrowableBricksDispenserBehavior((Item)h.m_203334_())));
        }
        if (RegistryConfigs.BOMB_ENABLED.get().booleanValue()) {
            BombsDispenserBehavior bombBehavior = new BombsDispenserBehavior();
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_ITEM.get()), (DispenseItemBehavior)bombBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_ITEM_ON.get()), (DispenseItemBehavior)bombBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_BLUE_ITEM.get()), (DispenseItemBehavior)bombBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_BLUE_ITEM_ON.get()), (DispenseItemBehavior)bombBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_SPIKY_ITEM.get()), (DispenseItemBehavior)bombBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_SPIKY_ITEM_ON.get()), (DispenseItemBehavior)bombBehavior);
        }
        if (CommonConfigs.Tweaks.PLACEABLE_GUNPOWDER.get().booleanValue()) {
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new GunpowderBehavior(Items.f_42403_));
        }
        if (RegistryConfigs.ROPE_ARROW_ENABLED.get().booleanValue()) {
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.ROPE_ARROW_ITEM.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level world, Position pos, ItemStack stack) {
                    CompoundTag com = stack.m_41783_();
                    int charges = stack.m_41776_();
                    if (com != null && com.m_128441_("Damage")) {
                        charges -= com.m_128451_("Damage");
                    }
                    RopeArrowEntity arrow = new RopeArrowEntity(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), charges);
                    arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                    return arrow;
                }
            });
        }
        boolean axe = CommonConfigs.Tweaks.AXE_DISPENSER_BEHAVIORS.get();
        boolean jar = RegistryConfigs.JAR_ENABLED.get();
        if (axe || jar) {
            for (Item i : Registry.f_122827_) {
                try {
                    if (jar && BucketHelper.isFishBucket(i)) {
                        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FishBucketJarDispenserBehavior(i));
                    }
                    if (!isForge || !axe || !(i instanceof AxeItem)) continue;
                    DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FakePlayerUseItemBehavior(i));
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.warn("Error white registering dispenser behavior for item {}: {}", (Object)i, (Object)e);
                }
            }
        }
    }

    public static class PancakeDiscBehavior
    extends OptionalDispenseItemBehavior {
        @Nonnull
        protected ItemStack m_7498_(BlockSource source, @Nonnull ItemStack stack) {
            BlockEntity blockEntity;
            Direction dir = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos pos = source.m_7961_().m_121945_(dir);
            ServerLevel world = source.m_7727_();
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() == Blocks.f_50131_ && (blockEntity = world.m_7702_(pos)) instanceof JukeboxBlockEntity) {
                JukeboxBlockEntity jukebox = (JukeboxBlockEntity)blockEntity;
                ItemStack currentRecord = jukebox.m_59524_();
                ((JukeboxBlock)state.m_60734_()).m_238345_(null, (LevelAccessor)world, pos, state, stack);
                world.m_5898_(null, 1010, pos, Item.m_41393_((Item)ModRegistry.PANCAKE_DISC.get()));
                return currentRecord;
            }
            return super.m_7498_(source, stack);
        }
    }

    public static class EnderPearlBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected EnderPearlBehavior() {
            super(Items.f_42584_);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            ServerLevel level = source.m_7727_();
            BlockPos pos = source.m_7961_();
            ThrownEnderpearl pearl = PearlMarker.getPearlToDispense(source, (Level)level, pos);
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            pearl.m_6686_((double)direction.m_122429_(), (double)((float)direction.m_122430_() + 0.1f), (double)direction.m_122431_(), this.getPower(), this.getUncertainty());
            level.m_7967_((Entity)pearl);
            stack.m_41774_(1);
            return InteractionResultHolder.m_19090_((Object)stack);
        }

        protected void playSound(BlockSource source, boolean success) {
            source.m_7727_().m_46796_(1002, source.m_7961_(), 0);
        }

        protected float getUncertainty() {
            return 6.0f;
        }

        protected float getPower() {
            return 1.1f;
        }
    }

    private static class FlintAndSteelDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected FlintAndSteelDispenserBehavior(Item item) {
            super(item);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.m_7727_();
            BlockState state = world.m_8055_(blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            Block block = state.m_60734_();
            if (block instanceof ILightable) {
                ILightable block2 = (ILightable)block;
                if (block2.lightUp(null, state, blockpos, (LevelAccessor)world, ILightable.FireSourceType.FLINT_AND_STEEL)) {
                    if (stack.m_220157_(1, world.f_46441_, null)) {
                        stack.m_41764_(0);
                    }
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
    }

    private static class BambooSpikesDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected BambooSpikesDispenserBehavior(Item item) {
            super(item);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.m_7727_();
            BlockState state = world.m_8055_(blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            if (state.m_60734_() instanceof BambooSpikesBlock) {
                if (BambooSpikesBlock.tryAddingPotion(state, (LevelAccessor)world, blockpos, stack)) {
                    return InteractionResultHolder.m_19090_((Object)new ItemStack((ItemLike)Items.f_42590_));
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
    }

    private static class PancakesDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected PancakesDispenserBehavior(Item item) {
            super(item);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.m_7727_();
            BlockState state = world.m_8055_(blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            Block block = state.m_60734_();
            if (block instanceof PancakeBlock) {
                PancakeBlock block2 = (PancakeBlock)block;
                if (block2.tryAcceptingFluid((Level)world, state, blockpos, (SoftFluid)VanillaSoftFluids.HONEY.get(), null, 1)) {
                    return InteractionResultHolder.m_19096_((Object)new ItemStack((ItemLike)Items.f_42590_));
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
    }

    private static class FakePlayerUseItemBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected FakePlayerUseItemBehavior(Item item) {
            super(item);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            ServerLevel level = source.m_7727_();
            Direction dir = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos pos = source.m_7961_().m_121945_(dir);
            Player fp = MiscUtils.getFakePlayer((Level)level);
            fp.m_21008_(InteractionHand.MAIN_HAND, stack);
            UseOnContext context = new UseOnContext(fp, InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), dir, pos, false));
            InteractionResult v = stack.m_41661_(context);
            if (v.m_19077_()) {
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)false);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
    }

    private static class BombsDispenserBehavior
    extends AbstractProjectileDispenseBehavior {
        private BombsDispenserBehavior() {
        }

        protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
            return new BombEntity(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_(), ((BombItem)stackIn.m_41720_()).getType());
        }

        protected float m_7101_() {
            return 11.0f;
        }

        protected float m_7104_() {
            return 1.3f;
        }
    }

    public static class GunpowderBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected GunpowderBehavior(Item item) {
            super(item);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos blockpos = source.m_7961_().m_121945_(direction);
            Direction direction1 = source.m_7727_().m_46859_(blockpos.m_7495_()) ? direction : Direction.UP;
            InteractionResult result = ItemsUtil.place((BlockPlaceContext)new DirectionalPlaceContext((Level)source.m_7727_(), blockpos, direction, stack, direction1), ModRegistry.GUNPOWDER_BLOCK.get());
            if (result.m_19077_()) {
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
    }

    private static class FishBucketJarDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected FishBucketJarDispenserBehavior(Item item) {
            super(item);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.m_7727_();
            BlockEntity blockEntity = world.m_7702_(blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            if (blockEntity instanceof JarBlockTile) {
                JarBlockTile tile = (JarBlockTile)blockEntity;
                if (tile.fluidHolder.isEmpty() && tile.m_7983_() && tile.mobContainer.interactWithBucket(stack, (Level)world, blockpos, null, null)) {
                    tile.m_6596_();
                    return InteractionResultHolder.m_19090_((Object)new ItemStack((ItemLike)Items.f_42446_));
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
    }

    private static class ThrowableBricksDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected ThrowableBricksDispenserBehavior(Item item) {
            super(item);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            ServerLevel world = source.m_7727_();
            Position dispensePosition = DispenserBlock.m_52720_((BlockSource)source);
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            Projectile projectileEntity = this.getProjectileEntity((Level)world, dispensePosition, stack);
            projectileEntity.m_6686_((double)direction.m_122429_(), (double)((float)direction.m_122430_() + 0.1f), (double)direction.m_122431_(), this.getProjectileVelocity(), this.getProjectileInaccuracy());
            world.m_7967_((Entity)projectileEntity);
            stack.m_41774_(1);
            return InteractionResultHolder.m_19090_((Object)stack);
        }

        protected void playSound(BlockSource source, boolean success) {
            source.m_7727_().m_6263_(null, source.m_7096_() + 0.5, source.m_7098_() + 0.5, source.m_7094_() + 0.5, SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (source.m_7727_().m_213780_().m_188501_() * 0.4f + 0.8f));
        }

        protected Projectile getProjectileEntity(Level worldIn, Position position, ItemStack stackIn) {
            return new ThrowableBrickEntity(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_());
        }

        protected float getProjectileInaccuracy() {
            return 7.0f;
        }

        protected float getProjectileVelocity() {
            return 0.9f;
        }
    }
}

