/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidConsumer;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidProvider;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.fluids.VanillaSoftFluids;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.FluidsUtil;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.InspirationCompat;
import net.mehvahdjukaar.supplementaries.reg.ModSoftFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class FaucetInteractionsRegistry {
    public static void registerBehaviors() {
        FaucetBlockTile.registerInteraction(new SoftFluidProviderInteraction());
        FaucetBlockTile.registerInteraction(new WaterCauldronInteraction());
        FaucetBlockTile.registerInteraction(new LavaCauldronInteraction());
        FaucetBlockTile.registerInteraction(new PowderSnowCauldronInteraction());
        FaucetBlockTile.registerInteraction(new BeehiveInteraction());
        FaucetBlockTile.registerInteraction(new SoftFluidTankInteraction());
        FaucetBlockTile.registerInteraction(new ForgeFluidTankInteraction());
        FaucetBlockTile.registerInteraction(new WaterBlockInteraction());
        FaucetBlockTile.registerInteraction(new SpongeInteraction());
        FaucetBlockTile.registerInteraction(new XPDroppingInteraction());
        if (CompatHandler.BUZZIER_BEES) {
            FaucetBlockTile.registerInteraction(new HoneyPotInteraction());
        }
        if (CompatHandler.AUTUMNITY) {
            FaucetBlockTile.registerInteraction(new SappyLogInteraction());
        }
    }

    private static void prepareToTransferBottle(SoftFluidTank tempFluidHolder, SoftFluid softFluid) {
        tempFluidHolder.fill(softFluid);
        tempFluidHolder.setCount(2);
    }

    private static void prepareToTransferBottle(SoftFluidTank tempFluidHolder, SoftFluid softFluid, CompoundTag tag) {
        tempFluidHolder.fill(softFluid, tag);
        tempFluidHolder.setCount(2);
    }

    private static void prepareToTransferBucket(SoftFluidTank tempFluidHolder, SoftFluid softFluid) {
        tempFluidHolder.fill(softFluid);
    }

    private static class SoftFluidProviderInteraction
    implements FaucetBlockTile.IBlockSourceInteraction,
    FaucetBlockTile.ITileSourceInteraction,
    FaucetBlockTile.ITileTargetInteraction,
    FaucetBlockTile.IBlockTargetInteraction {
        private SoftFluidProviderInteraction() {
        }

        @Override
        public int getTransferCooldown() {
            return FaucetBlockTile.IBlockSourceInteraction.super.getTransferCooldown();
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, FaucetBlockTile.FillAction fillAction) {
            return SoftFluidProviderInteraction.drainGeneric(level, faucetTank, pos, state, fillAction, state.m_60734_());
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockEntity tile, Direction dir, FaucetBlockTile.FillAction fillAction) {
            return SoftFluidProviderInteraction.drainGeneric(level, faucetTank, pos, tile.m_58900_(), fillAction, tile);
        }

        private static InteractionResult drainGeneric(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, FaucetBlockTile.FillAction fillAction, Object backBlock) {
            if (backBlock instanceof ISoftFluidProvider) {
                ISoftFluidProvider provider = (ISoftFluidProvider)backBlock;
                Pair stack = provider.getProvidedFluid(level, state, pos);
                FaucetInteractionsRegistry.prepareToTransferBottle(faucetTank, (SoftFluid)stack.getFirst(), (CompoundTag)stack.getSecond());
                if (fillAction.tryExecute()) {
                    provider.consumeProvidedFluid(level, state, pos, faucetTank.getFluid(), faucetTank.getNbt(), 1);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }

        @Override
        public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state) {
            return this.tryFillGeneric(level, faucetTank, pos, state, state.m_60734_());
        }

        @Override
        public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockEntity tile) {
            return this.tryFillGeneric(level, faucetTank, pos, tile.m_58900_(), tile);
        }

        public InteractionResult tryFillGeneric(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, Object object) {
            if (object instanceof ISoftFluidConsumer) {
                ISoftFluidConsumer consumer = (ISoftFluidConsumer)object;
                return consumer.tryAcceptingFluid(level, state, pos, faucetTank.getFluid(), faucetTank.getNbt(), 1) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
    }

    private static class WaterCauldronInteraction
    implements FaucetBlockTile.IBlockSourceInteraction,
    FaucetBlockTile.IBlockTargetInteraction {
        private WaterCauldronInteraction() {
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, FaucetBlockTile.FillAction fillAction) {
            if (state.m_60713_(Blocks.f_152476_)) {
                int waterLevel = (Integer)state.m_61143_((Property)BlockStateProperties.f_61418_);
                if (waterLevel > 0) {
                    if (CompatHandler.INSPIRATIONS) {
                        return InspirationCompat.doCauldronStuff(level.m_7702_(pos), faucetTank, fillAction);
                    }
                    FaucetInteractionsRegistry.prepareToTransferBottle(faucetTank, (SoftFluid)VanillaSoftFluids.WATER.get());
                    if (fillAction.tryExecute()) {
                        if (waterLevel > 1) {
                            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(waterLevel - 1)), 3);
                        } else {
                            level.m_7731_(pos, Blocks.f_50256_.m_49966_(), 3);
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }

        @Override
        public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state) {
            if (state.m_60734_() instanceof AbstractCauldronBlock) {
                SoftFluid softFluid = faucetTank.getFluid();
                if (CompatHandler.INSPIRATIONS) {
                    return InspirationCompat.tryAddFluid(level.m_7702_(pos), faucetTank);
                }
                if (softFluid == VanillaSoftFluids.WATER.get()) {
                    if (state.m_60713_(Blocks.f_152476_)) {
                        int levels = (Integer)state.m_61143_((Property)BlockStateProperties.f_61418_);
                        if (levels < 3) {
                            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(levels + 1)), 3);
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.FAIL;
                    }
                    if (state.m_60713_(Blocks.f_50256_)) {
                        level.m_7731_(pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(1)), 3);
                        return InteractionResult.SUCCESS;
                    }
                }
            }
            return InteractionResult.PASS;
        }
    }

    private static class LavaCauldronInteraction
    implements FaucetBlockTile.IBlockSourceInteraction,
    FaucetBlockTile.IBlockTargetInteraction {
        private LavaCauldronInteraction() {
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, FaucetBlockTile.FillAction fillAction) {
            if (state.m_60713_(Blocks.f_152477_)) {
                FaucetInteractionsRegistry.prepareToTransferBucket(faucetTank, (SoftFluid)VanillaSoftFluids.LAVA.get());
                if (fillAction.tryExecute()) {
                    level.m_7731_(pos, Blocks.f_50256_.m_49966_(), 3);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }

        @Override
        public int getTransferCooldown() {
            return FaucetBlockTile.IBlockSourceInteraction.super.getTransferCooldown() * 3;
        }

        @Override
        public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state) {
            if (state.m_60713_(Blocks.f_50256_) && faucetTank.getFluid() == VanillaSoftFluids.LAVA.get()) {
                if (faucetTank.getCount() == 5) {
                    level.m_7731_(pos, Blocks.f_152477_.m_49966_(), 3);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
    }

    private static class PowderSnowCauldronInteraction
    implements FaucetBlockTile.IBlockSourceInteraction,
    FaucetBlockTile.IBlockTargetInteraction {
        private PowderSnowCauldronInteraction() {
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, FaucetBlockTile.FillAction fillAction) {
            int waterLevel;
            if (state.m_60713_(Blocks.f_152478_) && (waterLevel = ((Integer)state.m_61143_((Property)BlockStateProperties.f_61418_)).intValue()) == 3) {
                FaucetInteractionsRegistry.prepareToTransferBucket(faucetTank, (SoftFluid)VanillaSoftFluids.POWDERED_SNOW.get());
                if (fillAction.tryExecute()) {
                    level.m_7731_(pos, Blocks.f_50256_.m_49966_(), 3);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }

        @Override
        public int getTransferCooldown() {
            return FaucetBlockTile.IBlockSourceInteraction.super.getTransferCooldown() * 3;
        }

        @Override
        public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state) {
            if (state.m_60713_(Blocks.f_50256_) && faucetTank.getFluid() == VanillaSoftFluids.POWDERED_SNOW.get()) {
                if (faucetTank.getCount() == 5) {
                    level.m_7731_(pos, (BlockState)Blocks.f_152478_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 3);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
    }

    private static class BeehiveInteraction
    implements FaucetBlockTile.IBlockSourceInteraction,
    FaucetBlockTile.IBlockTargetInteraction {
        private BeehiveInteraction() {
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, FaucetBlockTile.FillAction fillAction) {
            if (state.m_61138_((Property)BlockStateProperties.f_61421_)) {
                if ((Integer)state.m_61143_((Property)BlockStateProperties.f_61421_) == 5) {
                    FaucetInteractionsRegistry.prepareToTransferBottle(faucetTank, (SoftFluid)VanillaSoftFluids.HONEY.get());
                    if (fillAction.tryExecute()) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61421_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)BlockStateProperties.f_61421_) - 1)), 3);
                        return InteractionResult.SUCCESS;
                    }
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }

        @Override
        public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state) {
            SoftFluid fluid = faucetTank.getFluid();
            if (fluid == VanillaSoftFluids.HONEY.get() && state.m_61138_((Property)BlockStateProperties.f_61421_)) {
                int h = (Integer)state.m_61143_((Property)BlockStateProperties.f_61421_);
                if (h == 0) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61421_, (Comparable)Integer.valueOf(5)), 3);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
    }

    private static class SoftFluidTankInteraction
    implements FaucetBlockTile.ITileSourceInteraction,
    FaucetBlockTile.ITileTargetInteraction {
        private SoftFluidTankInteraction() {
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockEntity tile, Direction dir, FaucetBlockTile.FillAction fillAction) {
            ISoftFluidTankProvider holder;
            if (tile instanceof ISoftFluidTankProvider && (holder = (ISoftFluidTankProvider)tile).canInteractWithSoftFluidTank()) {
                SoftFluidTank fluidHolder = holder.getSoftFluidTank();
                faucetTank.copy(fluidHolder);
                faucetTank.setCount(2);
                if (fillAction.tryExecute()) {
                    fluidHolder.shrink(1);
                    tile.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }

        @Override
        public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockEntity tile) {
            if (tile instanceof ISoftFluidTankProvider) {
                ISoftFluidTankProvider holder = (ISoftFluidTankProvider)tile;
                SoftFluidTank tank = holder.getSoftFluidTank();
                boolean result = faucetTank.tryTransferFluid(tank, faucetTank.getCount() - 1);
                if (result) {
                    tile.m_6596_();
                    faucetTank.fillCount();
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
    }

    private static class ForgeFluidTankInteraction
    implements FaucetBlockTile.ITileSourceInteraction,
    FaucetBlockTile.ITileTargetInteraction {
        private ForgeFluidTankInteraction() {
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockEntity tile, Direction dir, FaucetBlockTile.FillAction fillAction) {
            if (FluidsUtil.tryExtractFromFluidHandler(tile, tile.m_58900_().m_60734_(), dir, faucetTank, fillAction)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }

        @Override
        public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockEntity tile) {
            return FluidsUtil.tryFillFluidTank(tile, faucetTank) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
    }

    private static class WaterBlockInteraction
    implements FaucetBlockTile.IFluidSourceInteraction {
        private WaterBlockInteraction() {
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, FluidState fluidState, FaucetBlockTile.FillAction fillAction) {
            if (fluidState.m_76152_() == Fluids.f_76193_) {
                FaucetInteractionsRegistry.prepareToTransferBottle(faucetTank, (SoftFluid)VanillaSoftFluids.WATER.get());
                if (fillAction.tryExecute()) {
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
    }

    private static class SpongeInteraction
    implements FaucetBlockTile.IBlockTargetInteraction {
        private SpongeInteraction() {
        }

        @Override
        public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state) {
            if (state.m_60734_() == Blocks.f_50056_) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
    }

    private static class XPDroppingInteraction
    implements FaucetBlockTile.IBlockTargetInteraction {
        private XPDroppingInteraction() {
        }

        @Override
        public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state) {
            SoftFluid fluid = faucetTank.getFluid();
            if (state.m_60795_()) {
                if (fluid == VanillaSoftFluids.XP.get()) {
                    this.dropXP(level, pos);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }

        private void dropXP(Level level, BlockPos pos) {
            int xp;
            for (int i = 3 + level.f_46441_.m_188503_(5) + level.f_46441_.m_188503_(5); i > 0; i -= xp) {
                xp = ExperienceOrb.m_20782_((int)i);
                ExperienceOrb orb = new ExperienceOrb(level, (double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() - 0.125f), (double)pos.m_123343_() + 0.5, xp);
                orb.m_20256_(new Vec3(0.0, 0.0, 0.0));
                level.m_7967_((Entity)orb);
            }
            float f = (level.f_46441_.m_188501_() - 0.5f) / 4.0f;
            level.m_5594_(null, pos, SoundEvents.f_11752_, SoundSource.BLOCKS, 0.3f, 0.5f + f);
        }
    }

    private static class HoneyPotInteraction
    implements FaucetBlockTile.IBlockSourceInteraction,
    FaucetBlockTile.IBlockTargetInteraction {
        private HoneyPotInteraction() {
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, FaucetBlockTile.FillAction fillAction) {
            if (state.m_61138_((Property)ModBlockProperties.HONEY_LEVEL_POT)) {
                if ((Integer)state.m_61143_((Property)ModBlockProperties.HONEY_LEVEL_POT) > 0) {
                    FaucetInteractionsRegistry.prepareToTransferBottle(faucetTank, (SoftFluid)VanillaSoftFluids.HONEY.get());
                    if (fillAction.tryExecute()) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)ModBlockProperties.HONEY_LEVEL_POT, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)ModBlockProperties.HONEY_LEVEL_POT) - 1)), 3);
                        return InteractionResult.SUCCESS;
                    }
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }

        @Override
        public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state) {
            SoftFluid fluid = faucetTank.getFluid();
            if (fluid == VanillaSoftFluids.HONEY.get() && state.m_61138_((Property)ModBlockProperties.HONEY_LEVEL_POT)) {
                int h = (Integer)state.m_61143_((Property)ModBlockProperties.HONEY_LEVEL_POT);
                if (h < 4) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)ModBlockProperties.HONEY_LEVEL_POT, (Comparable)Integer.valueOf(h + 1)), 3);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
    }

    private static class SappyLogInteraction
    implements FaucetBlockTile.IBlockSourceInteraction {
        private SappyLogInteraction() {
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, FaucetBlockTile.FillAction fillAction) {
            Block backBlock = state.m_60734_();
            if (backBlock == CompatObjects.SAPPY_MAPLE_LOG.get() || backBlock == CompatObjects.SAPPY_MAPLE_WOOD.get()) {
                FaucetInteractionsRegistry.prepareToTransferBottle(faucetTank, (SoftFluid)ModSoftFluids.SAP.get());
                if (fillAction.tryExecute()) {
                    Optional log = Registry.f_122824_.m_6612_(new ResourceLocation(Utils.getID((Block)backBlock).toString().replace("sappy", "stripped")));
                    log.ifPresent(block -> level.m_7731_(pos, block.m_152465_(state), 3));
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
    }

    private static class MalumInteraction
    implements FaucetBlockTile.IBlockSourceInteraction {
        private MalumInteraction() {
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, FaucetBlockTile.FillAction fillAction) {
            return InteractionResult.PASS;
        }
    }
}

