/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.misc.StasisEnchantment;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;

public class LootTablesInjects {
    private static final List<BiConsumer<Consumer<LootPool.Builder>, TableType>> LOOT_INJECTS = new ArrayList<BiConsumer<Consumer<LootPool.Builder>, TableType>>();

    public static void init() {
        if (RegistryConfigs.GLOBE_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectGlobe);
        }
        if (RegistryConfigs.QUIVER_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectQuiver);
        }
        if (RegistryConfigs.ROPE_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectRope);
        }
        if (RegistryConfigs.FLAX_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectFlax);
        }
        if (RegistryConfigs.BOMB_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectBlueBomb);
        }
        if (RegistryConfigs.BOMB_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectBomb);
        }
        if (StasisEnchantment.ENABLED) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectStasis);
        }
        if (RegistryConfigs.BAMBOO_SPIKES_ENABLED.get().booleanValue() && RegistryConfigs.TIPPED_SPIKES_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectSpikes);
        }
    }

    public static void injectLootTables(ResourceLocation name, Consumer<LootPool.Builder> builder) {
        String nameSpace = name.m_135827_();
        if (nameSpace.equals("minecraft") || nameSpace.equals("repurposed_structures")) {
            TableType type = LootHelper.getType(name.toString());
            if (name.toString().contains("fishing")) {
                boolean bl = true;
            }
            if (type != TableType.OTHER) {
                LOOT_INJECTS.forEach(i -> i.accept(builder, type));
            }
        }
    }

    private static void injectLootPool(Consumer<LootPool.Builder> consumer, TableType type, String name) {
        String id = type.toString().toLowerCase(Locale.ROOT) + "_" + name;
        LootPool.Builder pool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)Supplementaries.res("inject/" + id)));
        ForgeHelper.setPoolName((LootPool.Builder)pool, (String)("supp_" + name));
        consumer.accept(pool);
    }

    public static void tryInjectGlobe(Consumer<LootPool.Builder> e, TableType type) {
        if (type == TableType.SHIPWRECK_TREASURE) {
            LootTablesInjects.injectLootPool(e, type, "globe");
        }
    }

    private static void tryInjectQuiver(Consumer<LootPool.Builder> e, TableType type) {
        if (type == TableType.DUNGEON || type == TableType.MANSION) {
            LootTablesInjects.injectLootPool(e, type, "quiver");
        }
    }

    public static void tryInjectRope(Consumer<LootPool.Builder> e, TableType type) {
        if (type == TableType.MINESHAFT) {
            LootTablesInjects.injectLootPool(e, type, "rope");
        }
    }

    public static void tryInjectFlax(Consumer<LootPool.Builder> e, TableType type) {
        if (type == TableType.MINESHAFT || type == TableType.DUNGEON || type == TableType.SHIPWRECK_STORAGE || type == TableType.PILLAGER) {
            LootTablesInjects.injectLootPool(e, type, "flax");
        }
    }

    public static void tryInjectBlueBomb(Consumer<LootPool.Builder> e, TableType type) {
        if (type == TableType.STRONGHOLD || type == TableType.MINESHAFT || type == TableType.TEMPLE || type == TableType.FORTRESS || type == TableType.DUNGEON) {
            LootTablesInjects.injectLootPool(e, type, "blue_bomb");
        }
    }

    public static void tryInjectBomb(Consumer<LootPool.Builder> e, TableType type) {
        if (type == TableType.STRONGHOLD || type == TableType.MINESHAFT || type == TableType.TEMPLE || type == TableType.FORTRESS) {
            LootTablesInjects.injectLootPool(e, type, "bomb");
        }
    }

    public static void tryInjectSpikes(Consumer<LootPool.Builder> e, TableType type) {
        if (type == TableType.TEMPLE) {
            LootTablesInjects.injectLootPool(e, type, "spikes");
        }
    }

    public static void tryInjectStasis(Consumer<LootPool.Builder> e, TableType type) {
        if (type == TableType.END_CITY) {
            LootTablesInjects.injectLootPool(e, type, "stasis");
        }
    }

    private static class LootHelper {
        private static final boolean RS = CompatHandler.REPURPOSED_STRUCTURES;
        private static final Pattern RS_SHIPWRECK = Pattern.compile("repurposed_structures:chests/shipwreck/\\w*/treasure_chest");
        private static final Pattern RS_SHIPWRECK_STORAGE = Pattern.compile("repurposed_structures:chests/shipwreck/\\w*/supply_chest");
        private static final Pattern RS_TEMPLE = Pattern.compile("repurposed_structures:chests/temple/\\w*_chest");
        private static final Pattern RS_TEMPLE_DISPENSER = Pattern.compile("repurposed_structures:chests/temple/\\w*_dispenser");

        private LootHelper() {
        }

        public static TableType getType(String name) {
            if (LootHelper.isShipwreck(name)) {
                return TableType.SHIPWRECK_TREASURE;
            }
            if (LootHelper.isShipwreckStorage(name)) {
                return TableType.SHIPWRECK_STORAGE;
            }
            if (LootHelper.isMineshaft(name)) {
                return TableType.MINESHAFT;
            }
            if (LootHelper.isDungeon(name)) {
                return TableType.DUNGEON;
            }
            if (LootHelper.isTemple(name)) {
                return TableType.TEMPLE;
            }
            if (LootHelper.isTempleDispenser(name)) {
                return TableType.TEMPLE_DISPENSER;
            }
            if (LootHelper.isOutpost(name)) {
                return TableType.PILLAGER;
            }
            if (LootHelper.isStronghold(name)) {
                return TableType.STRONGHOLD;
            }
            if (LootHelper.isFortress(name)) {
                return TableType.FORTRESS;
            }
            if (LootHelper.isEndCity(name)) {
                return TableType.END_CITY;
            }
            if (LootHelper.isMansion(name)) {
                return TableType.MANSION;
            }
            if (LootHelper.isFishTreasure(name)) {
                return TableType.FISHING_TREASURE;
            }
            return TableType.OTHER;
        }

        private static boolean isFishTreasure(String name) {
            return name.equals(BuiltInLootTables.f_78722_.toString());
        }

        private static boolean isMansion(String name) {
            return name.equals(BuiltInLootTables.f_78689_.toString()) || RS && name.contains("repurposed_structures:chests/mansion");
        }

        private static boolean isShipwreck(String s) {
            return s.equals(BuiltInLootTables.f_78695_.toString()) || RS && RS_SHIPWRECK.matcher(s).matches();
        }

        private static boolean isShipwreckStorage(String s) {
            return s.equals(BuiltInLootTables.f_78694_.toString()) || RS && RS_SHIPWRECK_STORAGE.matcher(s).matches();
        }

        private static boolean isMineshaft(String s) {
            return s.equals(BuiltInLootTables.f_78759_.toString()) || RS && s.contains("repurposed_structures:chests/mineshaft");
        }

        private static boolean isOutpost(String s) {
            return s.equals(BuiltInLootTables.f_78696_.toString()) || RS && s.contains("repurposed_structures:chests/outpost");
        }

        private static boolean isDungeon(String s) {
            return s.equals(BuiltInLootTables.f_78742_.toString()) || RS && s.contains("repurposed_structures:chests/dungeon");
        }

        private static boolean isTemple(String s) {
            return s.equals(BuiltInLootTables.f_78686_.toString()) || RS && RS_TEMPLE.matcher(s).matches();
        }

        private static boolean isTempleDispenser(String s) {
            return s.equals(BuiltInLootTables.f_78686_.toString()) || RS && RS_TEMPLE_DISPENSER.matcher(s).matches();
        }

        private static boolean isStronghold(String s) {
            return s.equals(BuiltInLootTables.f_78762_.toString()) || RS && s.contains("repurposed_structures:chests/stronghold/nether_storage_room");
        }

        private static boolean isFortress(String s) {
            return s.equals(BuiltInLootTables.f_78760_.toString()) || RS && s.contains("repurposed_structures:chests/fortress");
        }

        private static boolean isEndCity(String s) {
            return s.equals(BuiltInLootTables.f_78741_.toString());
        }
    }

    public static enum TableType {
        OTHER,
        MINESHAFT,
        SHIPWRECK_TREASURE,
        PILLAGER,
        DUNGEON,
        PYRAMID,
        STRONGHOLD,
        TEMPLE,
        TEMPLE_DISPENSER,
        IGLOO,
        MANSION,
        FORTRESS,
        BASTION,
        RUIN,
        SHIPWRECK_STORAGE,
        END_CITY,
        FISHING_TREASURE;

    }
}

