/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import dev.architectury.injectables.annotations.PlatformOnly;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.JarBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SugarBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.common.utils.FluidsUtil;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FaucetBlock
extends WaterBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)15.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Utils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST = Utils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);
    protected static final VoxelShape SHAPE_EAST = Utils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    protected static final VoxelShape SHAPE_NORTH_JAR = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH_JAR = Utils.rotateVoxelShape((VoxelShape)SHAPE_NORTH_JAR, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST_JAR = Utils.rotateVoxelShape((VoxelShape)SHAPE_NORTH_JAR, (Direction)Direction.WEST);
    protected static final VoxelShape SHAPE_EAST_JAR = Utils.rotateVoxelShape((VoxelShape)SHAPE_NORTH_JAR, (Direction)Direction.EAST);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty HAS_WATER = ModBlockProperties.HAS_WATER;
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL_0_7;
    public static final BooleanProperty HAS_JAR = ModBlockProperties.HAS_JAR;

    public FaucetBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(s -> (Integer)s.m_61143_((Property)LIGHT_LEVEL)));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HAS_JAR, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_WATER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)HAS_JAR)).booleanValue()) {
            return switch ((Direction)state.m_61143_((Property)FACING)) {
                default -> SHAPE_NORTH_JAR;
                case Direction.SOUTH -> SHAPE_SOUTH_JAR;
                case Direction.EAST -> SHAPE_EAST_JAR;
                case Direction.WEST -> SHAPE_WEST_JAR;
            };
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean enabled = (Boolean)state.m_61143_((Property)ENABLED);
        float f = enabled ? 1.0f : 1.2f;
        worldIn.m_5594_(null, pos, ModSounds.FAUCET.get(), SoundSource.BLOCKS, 1.0f, f);
        worldIn.m_142346_((Entity)player, enabled ? GameEvent.f_223702_ : GameEvent.f_223703_, pos);
        this.updateBlock(state, worldIn, pos, true);
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        boolean hasWater = this.updateTileFluid(state, pos, (LevelAccessor)worldIn);
        if (hasWater != (Boolean)state.m_61143_((Property)HAS_WATER)) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)HAS_WATER, (Comparable)Boolean.valueOf(hasWater)));
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN) {
            boolean canConnectDown = this.canConnect(facingState, worldIn, facingPos, facing.m_122424_());
            return (BlockState)stateIn.m_61124_((Property)HAS_JAR, (Comparable)Boolean.valueOf(canConnectDown));
        }
        if (facing == ((Direction)stateIn.m_61143_((Property)FACING)).m_122424_()) {
            boolean hasWater = this.updateTileFluid(stateIn, currentPos, worldIn);
            return (BlockState)stateIn.m_61124_((Property)HAS_WATER, (Comparable)Boolean.valueOf(hasWater));
        }
        return stateIn;
    }

    public boolean updateTileFluid(BlockState state, BlockPos pos, LevelAccessor world) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FaucetBlockTile) {
            FaucetBlockTile tile = (FaucetBlockTile)blockEntity;
            if (world instanceof Level) {
                Level level = (Level)world;
                return tile.updateContainedFluidVisuals(level, pos, state);
            }
        }
        return false;
    }

    @PlatformOnly(value={"forge"})
    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FaucetBlockTile) {
            FaucetBlockTile tile = (FaucetBlockTile)blockEntity;
            if (world instanceof Level) {
                Level level = (Level)world;
                boolean water = tile.updateContainedFluidVisuals(level, pos, state);
                if ((Boolean)state.m_61143_((Property)HAS_WATER) != water) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_WATER, (Comparable)Boolean.valueOf(water)), 2);
                }
            }
        }
    }

    private boolean canConnect(BlockState downState, LevelAccessor world, BlockPos pos, Direction dir) {
        Level level;
        if (downState.m_60734_() instanceof JarBlock) {
            return true;
        }
        if (downState.m_204336_(ModTags.POURING_TANK)) {
            return false;
        }
        if (downState.m_61138_((Property)BlockStateProperties.f_61421_)) {
            return true;
        }
        return world instanceof Level && FluidsUtil.hasFluidHandler(level = (Level)world, pos, dir);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.m_6861_(state, world, pos, neighborBlock, fromPos, moving);
        this.updateBlock(state, world, pos, false);
    }

    public void updateBlock(BlockState state, Level world, BlockPos pos, boolean toggle) {
        boolean hasWater;
        boolean isPowered = world.m_46753_(pos);
        if (isPowered != (Boolean)state.m_61143_((Property)POWERED) || toggle) {
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(toggle ^ (Boolean)state.m_61143_((Property)ENABLED))), 2);
        }
        if ((hasWater = this.updateTileFluid(state, pos, (LevelAccessor)world)) != (Boolean)state.m_61143_((Property)HAS_WATER)) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)HAS_WATER, (Comparable)Boolean.valueOf(hasWater)));
        }
        if ((Boolean)state.m_61143_((Property)ENABLED) ^ toggle ^ isPowered && ((Boolean)state.m_61143_((Property)HAS_WATER)).booleanValue()) {
            this.trySolidifyConcrete(pos.m_7495_(), world);
        }
    }

    public void trySolidifyConcrete(BlockPos pos, Level world) {
        Block b = world.m_8055_(pos).m_60734_();
        if (b instanceof ConcretePowderBlock) {
            ConcretePowderBlock concretePowderBlock = (ConcretePowderBlock)b;
            world.m_7731_(pos, concretePowderBlock.f_52058_, 18);
        } else if (b instanceof SugarBlock) {
            world.m_7471_(pos, false);
        }
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) ^ (Boolean)state.m_61143_((Property)BlockStateProperties.f_61431_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ENABLED, POWERED, HAS_WATER, HAS_JAR, WATERLOGGED, LIGHT_LEVEL});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction dir = context.m_43719_().m_122434_() == Direction.Axis.Y ? Direction.NORTH : context.m_43719_();
        boolean water = world.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        boolean hasJar = this.canConnect(world.m_8055_(pos.m_7495_()), (LevelAccessor)world, pos.m_7495_(), Direction.UP);
        boolean powered = world.m_46753_(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir)).m_61124_((Property)HAS_JAR, (Comparable)Boolean.valueOf(hasJar))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        boolean flag = this.isOpen(state);
        if (((Boolean)state.m_61143_((Property)HAS_WATER)).booleanValue() && !((Boolean)state.m_61143_((Property)HAS_JAR)).booleanValue()) {
            double d = random.m_188501_();
            double d2 = flag ? 0.0 : 0.06;
            if (d > d2) {
                return;
            }
            float d3 = 0.125f;
            double x = (double)pos.m_123341_() + 0.5 + (double)d3 * ((double)random.m_188501_() - 0.5);
            double y = (double)pos.m_123342_() + 0.25;
            double z = (double)pos.m_123343_() + 0.5 + (double)d3 * ((double)random.m_188501_() - 0.5);
            int color = this.getTileParticleColor(pos, world);
            float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
            float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
            float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
            world.m_7106_((ParticleOptions)ModParticles.DRIPPING_LIQUID.get(), x, y, z, (double)r, (double)g, (double)b);
        }
    }

    public int getTileParticleColor(BlockPos pos, Level world) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FaucetBlockTile) {
            FaucetBlockTile te = (FaucetBlockTile)blockEntity;
            return te.tempFluidHolder.getParticleColor((LevelReader)world, pos);
        }
        return 4340983;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new FaucetBlockTile(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return BlockUtil.getTicker(pBlockEntityType, ModRegistry.FAUCET_TILE.get(), pLevel.f_46443_ ? null : FaucetBlockTile::tick);
    }
}

