/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlowerBoxBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlowerBoxBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class FlowerBoxBakedModel
implements CustomBakedModel {
    private final BakedModel box;
    private final BlockModelShaper blockModelShaper;
    private final ModelState rotation;

    public FlowerBoxBakedModel(BakedModel box, ModelState rotation) {
        this.box = box;
        this.blockModelShaper = Minecraft.m_91087_().m_91289_().m_110907_();
        this.rotation = rotation;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        try {
            quads.addAll(this.box.m_213637_(state, side, rand));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (state != null) {
                BlockState[] flowers = new BlockState[]{(BlockState)data.get(FlowerBoxBlockTile.FLOWER_0), (BlockState)data.get(FlowerBoxBlockTile.FLOWER_1), (BlockState)data.get(FlowerBoxBlockTile.FLOWER_2)};
                PoseStack poseStack = new PoseStack();
                Matrix4f rot = this.rotation.m_6189_().m_252783_();
                Matrix4f inv = rot.invert(new Matrix4f());
                poseStack.m_252931_(rot);
                poseStack.m_85837_(-0.3125, 0.0, 0.0);
                if (((Boolean)state.m_61143_((Property)FlowerBoxBlock.FLOOR)).booleanValue()) {
                    poseStack.m_85837_(0.0, 0.0, -0.3125);
                }
                poseStack.m_85841_(0.625f, 0.625f, 0.625f);
                poseStack.m_85837_(0.5, 0.5, 1.0);
                for (int i = 0; i < 3; ++i) {
                    BlockState flower = flowers[i];
                    if (flower == null || flower.m_60795_()) continue;
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.5 * (double)i, 0.0, 0.0);
                    if (flower.m_61138_((Property)BlockStateProperties.f_271526_)) {
                        poseStack.m_252931_(inv);
                        poseStack.m_85837_(0.25, 0.0, 0.25);
                    }
                    this.addBlockToModel(i, quads, flower, poseStack, side, rand);
                    if (flower.m_61138_((Property)DoublePlantBlock.f_52858_)) {
                        poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                        this.addBlockToModel(i, quads, (BlockState)flower.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER), poseStack, side, rand);
                    }
                    poseStack.m_85849_();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return quads;
    }

    private void addBlockToModel(int index, List<BakedQuad> quads, BlockState state, PoseStack poseStack, @Nullable Direction side, @NotNull RandomSource rand) {
        BakedModel model;
        ResourceLocation res = FlowerPotHandler.getSpecialFlowerModel(state.m_60734_().m_5456_());
        if (res != null) {
            if (state.m_61138_((Property)DoublePlantBlock.f_52858_) && state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
                return;
            }
            model = ClientHelper.getModel((ModelManager)this.blockModelShaper.m_110881_(), (ResourceLocation)res);
        } else {
            model = this.blockModelShaper.m_110893_(state);
        }
        List mimicQuads = model.m_213637_(state, side, rand);
        for (BakedQuad q : mimicQuads) {
            poseStack.m_85836_();
            int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
            if (res == null) {
                poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
                poseStack.m_85841_(0.6249f, 0.6249f, 0.6249f);
            } else {
                poseStack.m_252880_(-0.5f, -0.3125f, -0.5f);
            }
            VertexUtil.transformVertices((int[])v, (Matrix4f)poseStack.m_85850_().m_252922_());
            poseStack.m_85849_();
            quads.add(new BakedQuad(v, q.m_111305_() >= 0 ? index : q.m_111305_(), q.m_111306_(), q.m_173410_(), q.m_111307_()));
        }
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData extraModelData) {
        return this.box.m_6160_();
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }
}

