/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.block_models.JarBakedModel;
import net.mehvahdjukaar.supplementaries.client.renderers.VertexUtils;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CageBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class JarBlockTileRenderer
extends CageBlockTileRenderer<JarBlockTile> {
    private final ItemRenderer itemRenderer;
    private static final boolean USE_MODEL = false;

    public JarBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        Minecraft minecraft = Minecraft.m_91087_();
        this.itemRenderer = minecraft.m_91291_();
    }

    public static void renderFluid(float percentageFill, int color, int luminosity, ResourceLocation texture, PoseStack poseStack, MultiBufferSource bufferIn, int light, int combinedOverlayIn) {
        poseStack.m_85836_();
        if (luminosity != 0) {
            light = light & 0xF00000 | luminosity << 4;
        }
        VertexConsumer builder = ModMaterials.get(texture).m_119194_(bufferIn, RenderType::m_110470_);
        Vector3f dimensions = JarBakedModel.getJarLiquidDimensions();
        poseStack.m_85837_(0.5, (double)dimensions.z(), 0.5);
        VertexUtil.addCube((VertexConsumer)builder, (PoseStack)poseStack, (float)dimensions.x(), (float)(percentageFill * dimensions.y()), (int)light, (int)color);
        poseStack.m_85849_();
    }

    public void render(JarBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        MobContainer.MobNBTData data;
        long r = tile.m_58899_().m_121878_();
        Random rand = new Random(r);
        if (!tile.m_7983_()) {
            ItemStack stack = tile.getDisplayedItem();
            int height = tile.getDisplayedItem().m_41613_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 0.5, 0.5);
            matrixStackIn.m_252781_(RotHlpr.XN90);
            matrixStackIn.m_85837_(0.0, 0.0, -0.5);
            float scale = 0.5714286f;
            matrixStackIn.m_85841_(scale, scale, scale);
            for (float i = 0.0f; i < (float)height; i += 1.0f) {
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_((float)rand.nextInt(16) * 22.5f));
                matrixStackIn.m_252880_(0.0f, 0.0f, 1.0f / (16.0f * scale));
                BakedModel model = this.itemRenderer.m_174264_(stack, tile.m_58904_(), null, 0);
                this.itemRenderer.m_115143_(stack, ItemDisplayContext.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, model);
            }
            matrixStackIn.m_85849_();
        }
        if ((data = tile.mobContainer.getData()) != null) {
            if (data.is2DFish()) {
                matrixStackIn.m_85836_();
                long time = System.currentTimeMillis() + r;
                float angle = (float)(time % 28800L) / 80.0f;
                float angle2 = (float)(time % 1080L) / 3.0f;
                float angle3 = (float)(time % 126000L) / 350.0f;
                float wo = 0.015f * Mth.m_14031_((float)((float)(Math.PI * 2 * (double)angle2 / 360.0)));
                float ho = 0.1f * Mth.m_14031_((float)((float)(Math.PI * 2 * (double)angle3 / 360.0)));
                VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110463_());
                matrixStackIn.m_85837_(0.5, 0.5, 0.5);
                Quaternionf rotation = Axis.f_252436_.m_252977_(-angle);
                matrixStackIn.m_252781_(rotation);
                matrixStackIn.m_85841_(0.625f, 0.625f, 0.625f);
                Vector3f dimensions = JarBakedModel.getJarLiquidDimensions();
                matrixStackIn.m_85837_(0.0, -0.2, -0.335 * (double)(dimensions.x() / 0.5f));
                int fishType = data.getFishTexture();
                VertexUtils.renderFish(builder, matrixStackIn, wo, ho, fishType, combinedLightIn);
                matrixStackIn.m_85849_();
            } else {
                super.m_6922_(tile, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            Optional<SoftFluid> fluid = tile.mobContainer.shouldRenderWithFluid();
            if (fluid != null && fluid.isPresent()) {
                if (fluid.get() == BuiltInSoftFluids.WATER.get()) {
                    matrixStackIn.m_85836_();
                    Vector3f dimensions = JarBakedModel.getJarLiquidDimensions();
                    matrixStackIn.m_85837_(0.5, 0.0015 + (double)dimensions.z(), 0.5);
                    VertexConsumer builder = ModMaterials.SAND_MATERIAL.m_119194_(bufferIn, RenderType::m_110452_);
                    VertexUtil.addCube((VertexConsumer)builder, (PoseStack)matrixStackIn, (float)(0.99f * dimensions.x()), (float)(dimensions.y() / 12.0f), (int)combinedLightIn, (int)-1);
                    matrixStackIn.m_85849_();
                }
                matrixStackIn.m_85836_();
                SoftFluid s = fluid.get();
                JarBlockTileRenderer.renderFluid(0.75f, s.getTintColor(), 0, s.getStillTexture(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
                matrixStackIn.m_85849_();
            }
        }
        if (!tile.fluidHolder.isEmpty()) {
            JarBlockTileRenderer.renderFluid(tile.fluidHolder.getHeight(1.0f), tile.fluidHolder.getTintColor((BlockAndTintGetter)tile.m_58904_(), tile.m_58899_()), tile.fluidHolder.getFluid().getLuminosity(), tile.fluidHolder.getFluid().getStillTexture(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        }
    }
}

