/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import java.util.Arrays;
import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.block.IOnePlayerGui;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetTextHolderPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class TextHolderEditScreen<T extends BlockEntity>
extends Screen {
    protected final T tile;
    protected final String[][] messages;
    protected final int totalLines;
    protected TextFieldHelper textInputUtil;
    protected int lineIndex = 0;
    protected int textHolderIndex = 0;
    protected int updateCounter;

    protected TextHolderEditScreen(T tile, Component title) {
        super(title);
        this.tile = tile;
        boolean filtering = Minecraft.m_91087_().m_167974_();
        this.messages = (String[][])IntStream.range(0, ((ITextHolderProvider)tile).textHoldersCount()).mapToObj(i -> (String[])IntStream.range(0, ((ITextHolderProvider)tile).getTextHolder(i).size()).mapToObj(j -> ((ITextHolderProvider)tile).getTextHolder(i).getMessage(j, filtering)).map(Component::getString).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
        this.totalLines = Arrays.stream(this.messages).mapToInt(innerArray -> ((String[])innerArray).length).sum();
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        this.textInputUtil.m_95143_(codePoint);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollText((int)delta);
        return true;
    }

    protected boolean canScroll() {
        return true;
    }

    protected void scrollText(int amount) {
        if (this.canScroll()) {
            this.lineIndex -= amount;
            while (this.lineIndex < 0) {
                this.lineIndex += this.totalLines;
            }
            while (this.lineIndex >= this.messages[this.textHolderIndex].length) {
                this.lineIndex -= this.messages[this.textHolderIndex].length;
                ++this.textHolderIndex;
                this.textHolderIndex %= this.messages.length;
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.scrollText(1);
            return true;
        }
        if (keyCode != 264 && keyCode != 257 && keyCode != 335) {
            return this.textInputUtil.m_95145_(keyCode) || super.m_7933_(keyCode, scanCode, modifiers);
        }
        this.scrollText(-1);
        return true;
    }

    public void m_86600_() {
        ++this.updateCounter;
        if (!this.isValid()) {
            this.close();
        }
    }

    private boolean isValid() {
        return this.f_96541_ != null && this.f_96541_.f_91074_ != null && !this.tile.m_58901_() && !((IOnePlayerGui)this.tile).playerIsTooFarAwayToEdit(this.tile.m_58904_(), this.tile.m_58899_(), this.f_96541_.f_91074_.m_20148_());
    }

    public void m_7379_() {
        this.close();
    }

    public void m_7861_() {
        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundSetTextHolderPacket(this.tile.m_58899_(), this.messages));
    }

    private void close() {
        this.tile.m_6596_();
        this.f_96541_.m_91152_(null);
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.close()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120, 200, 20).m_253136_());
        this.textInputUtil = new TextFieldHelper(() -> this.messages[this.textHolderIndex][this.lineIndex], h -> {
            this.messages[this.textHolderIndex][this.lineIndex] = h;
            ((ITextHolderProvider)this.tile).getTextHolder(this.textHolderIndex).setMessage(this.lineIndex, (Component)Component.m_237113_((String)h));
        }, TextFieldHelper.m_95153_((Minecraft)this.f_96541_), TextFieldHelper.m_95182_((Minecraft)this.f_96541_), s -> this.f_96541_.f_91062_.m_92895_(s) <= ((ITextHolderProvider)this.tile).getTextHolder(this.textHolderIndex).getMaxLineVisualWidth());
    }
}

