/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import dev.architectury.injectables.annotations.PlatformOnly;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CandleSkullBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCandleSkullBlock
extends AbstractCandleBlock
implements EntityBlock,
ILightable,
IWashable {
    protected static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.m_137537_(() -> {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        map.defaultReturnValue(List.of());
        map.put(1, List.of(new Vec3(0.5, 1.0, 0.5)));
        map.put(2, List.of(new Vec3(0.375, 0.94, 0.5), new Vec3(0.625, 1.0, 0.44)));
        map.put(3, List.of(new Vec3(0.5, 0.813, 0.625), new Vec3(0.375, 0.94, 0.5), new Vec3(0.56, 1.0, 0.44)));
        map.put(4, List.of(new Vec3(0.44, 0.813, 0.56), new Vec3(0.625, 0.94, 0.56), new Vec3(0.375, 0.94, 0.375), new Vec3(0.56, 1.0, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)map);
    });
    protected static final VoxelShape BASE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    protected static final VoxelShape ONE_AABB = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0));
    protected static final VoxelShape TWO_AABB = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)5.0, (double)8.0, (double)6.0, (double)11.0, (double)14.0, (double)9.0));
    protected static final VoxelShape THREE_AABB = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)5.0, (double)8.0, (double)6.0, (double)10.0, (double)14.0, (double)11.0));
    protected static final VoxelShape FOUR_AABB = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)14.0, (double)10.0));
    public static final IntegerProperty CANDLES = BlockStateProperties.f_155994_;
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    private final Supplier<ParticleType<? extends ParticleOptions>> particle;

    protected AbstractCandleSkullBlock(BlockBehaviour.Properties properties, Supplier<ParticleType<? extends ParticleOptions>> particle) {
        super(properties.m_60953_(CandleBlock.f_152793_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CANDLES, (Comparable)Integer.valueOf(1)));
        this.particle = particle;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{CANDLES, LIT});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CandleSkullBlockTile(pPos, pState);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof CandleSkullBlockTile) {
            CandleSkullBlockTile tile = (CandleSkullBlockTile)((Object)object);
            List loot = ((BlockState)tile.getCandle().m_61124_((Property)CANDLES, (Comparable)((Integer)state.m_61143_((Property)CANDLES)))).m_287290_(builder);
            BlockEntity skullTile = tile.getSkullTile();
            if (skullTile != null) {
                BlockState skull = skullTile.m_58900_();
                builder = builder.m_287289_(LootContextParams.f_81462_, (Object)skullTile);
                loot.addAll(skull.m_287290_(builder));
            }
            return loot;
        }
        return super.m_49635_(state, builder);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CandleSkullBlockTile) {
            CandleSkullBlockTile tile = (CandleSkullBlockTile)blockEntity;
            return tile.getSkullItem();
        }
        return super.m_7397_(level, pos, state);
    }

    @PlatformOnly(value={"forge"})
    public ItemStack getCloneItemStack(BlockState state, HitResult hitResult, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CandleSkullBlockTile) {
            CandleSkullBlockTile tile = (CandleSkullBlockTile)blockEntity;
            double y = hitResult.m_82450_().f_82480_;
            boolean up = y % (double)((int)y) > 0.5;
            return up ? tile.getCandle().m_60734_().m_7397_(world, pos, state) : tile.getSkullItem();
        }
        return super.m_7397_(world, pos, state);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Integer)pState.m_61143_((Property)CANDLES)) {
            default -> ONE_AABB;
            case 2 -> TWO_AABB;
            case 3 -> THREE_AABB;
            case 4 -> FOUR_AABB;
        };
    }

    protected Iterable<Vec3> m_142199_(BlockState pState) {
        return (Iterable)PARTICLE_OFFSETS.get(((Integer)pState.m_61143_((Property)CANDLES)).intValue());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHit) {
        if (Utils.mayBuild((Player)player, (BlockPos)pos)) {
            Item item;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_204117_(ItemTags.f_144319_) && (item = stack.m_41720_()) instanceof BlockItem) {
                CandleSkullBlockTile tile;
                BlockEntity blockEntity;
                BlockItem blockItem = (BlockItem)item;
                int count = (Integer)state.m_61143_((Property)CANDLES);
                if (count < 4 && CommonConfigs.Tweaks.SKULL_CANDLES_MULTIPLE.get().booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof CandleSkullBlockTile && (tile = (CandleSkullBlockTile)blockEntity).getCandle().m_60734_().m_5456_() == stack.m_41720_()) {
                    SoundType sound = blockItem.m_40614_().m_49966_().m_60827_();
                    level.m_5594_(player, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)CANDLES, (Comparable)Integer.valueOf(count + 1)), 2);
                    level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                return InteractionResult.PASS;
            }
            return this.interactWithPlayer(state, level, pos, player, hand);
        }
        return InteractionResult.PASS;
    }

    public boolean isLitUp(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    public BlockState toggleLitState(BlockState state, boolean lit) {
        return (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit));
    }

    public boolean canBeExtinguishedBy(ItemStack item) {
        return item.m_41619_() || super.canBeExtinguishedBy(item);
    }

    public void playExtinguishSound(LevelAccessor world, BlockPos pos) {
        world.m_5594_(null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void spawnSmokeParticles(BlockState state, BlockPos pos, LevelAccessor level) {
        this.m_142199_(state).forEach(vec3 -> level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + vec3.m_7096_(), (double)pos.m_123342_() + vec3.m_7098_(), (double)pos.m_123343_() + vec3.m_7094_(), 0.0, (double)0.1f, 0.0));
    }

    public boolean tryWash(Level level, BlockPos pos, BlockState state) {
        Block n;
        CandleSkullBlockTile tile;
        BlockState c;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CandleSkullBlockTile && (c = (tile = (CandleSkullBlockTile)blockEntity).getCandle()) != null && (n = BlocksColorAPI.changeColor((Block)c.m_60734_(), null)) != null && n != c.m_60734_()) {
            tile.setCandle(n.m_152465_(c));
            tile.m_6596_();
            level.m_142346_(null, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return Utils.getTicker(type, ModRegistry.SKULL_CANDLE_TILE.get(), CandleSkullBlockTile::tick);
    }

    public void m_214162_(BlockState state, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            this.m_142199_(state).forEach(vec3 -> this.addParticlesAndSound(this.particle.get(), level, vec3.m_82520_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), randomSource));
        }
    }

    protected void addParticlesAndSound(ParticleType<?> particle, Level level, Vec3 vec3, RandomSource randomSource) {
        float f = randomSource.m_188501_();
        if (f < 0.3f) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                level.m_7785_(vec3.f_82479_ + 0.5, vec3.f_82480_ + 0.5, vec3.f_82481_ + 0.5, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + randomSource.m_188501_(), randomSource.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        level.m_7106_((ParticleOptions)particle, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
    }
}

