/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.api.IExtendedItem;
import net.mehvahdjukaar.supplementaries.common.entities.SlingshotProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventOverrideHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SlingshotItem
extends ProjectileWeaponItem
implements Vanishable,
IFirstPersonAnimationProvider,
IThirdPersonAnimationProvider {
    public SlingshotItem(Item.Properties properties) {
        super(properties);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        float power;
        Player player;
        ItemStack projectileStack;
        if (entity instanceof Player && !(projectileStack = (player = (Player)entity).m_6298_(stack)).m_41619_() && this.m_6437_().test(projectileStack) && (double)(power = this.getPowerForTime(stack, timeLeft)) >= 0.085) {
            int maxProjectiles = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack) > 0 ? 3 : 1;
            ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
            for (int p = 0; p < maxProjectiles && this.m_6437_().test(projectileStack); ++p) {
                projectiles.add(projectileStack.m_41777_());
                if (!player.m_150110_().f_35937_) {
                    projectileStack.m_41774_(1);
                    if (projectileStack.m_41619_()) {
                        player.m_150109_().m_36057_(projectileStack);
                    }
                }
                projectileStack = player.m_6298_(stack);
            }
            if (!world.f_46443_) {
                float[] pitches = SlingshotItem.getShotPitches(world.m_213780_());
                int count = projectiles.size();
                float angle = 10.0f;
                for (int j = 0; j < count; ++j) {
                    boolean stasis = EnchantmentHelper.m_44843_((Enchantment)ModRegistry.STASIS_ENCHANTMENT.get(), (ItemStack)stack) != 0;
                    InteractionHand hand = player.m_7655_();
                    power = (float)((double)power * ((CommonConfigs.Tools.SLINGSHOT_RANGE.get() + (stasis ? 0.5 : 0.0)) * 1.1));
                    SlingshotItem.shootProjectile(world, entity, hand, stack, (ItemStack)projectiles.get(j), count == 1 ? 1.0f : pitches[j], power, 1.0f, angle * ((float)j - (float)(count - 1) / 2.0f));
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    private static void shootProjectile(Level level, LivingEntity entity, InteractionHand hand, ItemStack stack, ItemStack projectileStack, float soundPitch, float power, float accuracy, float yaw) {
        SlingshotProjectileEntity projectile = new SlingshotProjectileEntity(entity, level, projectileStack, stack);
        Vec3 vector3d1 = entity.m_20289_(1.0f);
        Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(yaw * ((float)Math.PI / 180)), vector3d1.m_7096_(), vector3d1.m_7098_(), vector3d1.m_7094_());
        Vector3f vector3f = entity.m_20252_(1.0f).m_252839_();
        vector3f.rotate((Quaternionfc)quaternionf);
        projectile.m_6686_(vector3f.x(), vector3f.y(), vector3f.z(), power, accuracy);
        stack.m_41622_(1, entity, p -> p.m_21190_(hand));
        level.m_7967_((Entity)projectile);
        level.m_6269_(null, (Entity)entity, ModSounds.SLINGSHOT_SHOOT.get(), SoundSource.PLAYERS, 1.0f, soundPitch * (1.0f / (level.f_46441_.m_188501_() * 0.3f + 0.9f) + power * 0.6f));
    }

    private static float[] getShotPitches(RandomSource random) {
        boolean flag = random.m_188499_();
        return new float[]{SlingshotItem.getRandomShotPitch(random, flag), 1.0f, SlingshotItem.getRandomShotPitch(random, !flag)};
    }

    private static float getRandomShotPitch(RandomSource random, boolean left) {
        float f = left ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f;
    }

    public float getPowerForTime(ItemStack stack, float timeLeft) {
        float useTime = (float)this.m_8105_(stack) - timeLeft;
        float f = useTime / (float)SlingshotItem.getChargeDuration(stack);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public static int getChargeDuration(ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        int maxCharge = CommonConfigs.Tools.SLINGSHOT_CHARGE.get();
        return i == 0 ? maxCharge : maxCharge - maxCharge / 4 * i;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        boolean flag = this.m_6437_().test(player.m_6298_(itemstack));
        if (!flag) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        player.m_9236_().m_6269_(player, (Entity)player, this.getChargeSound(itemstack), SoundSource.PLAYERS, 1.0f, 1.0f * (1.0f / (world.f_46441_.m_188501_() * 0.3f + 0.9f)));
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public SoundEvent getChargeSound(ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        return switch (i) {
            case 0 -> ModSounds.SLINGSHOT_CHARGE_0.get();
            case 1 -> ModSounds.SLINGSHOT_CHARGE_1.get();
            case 2 -> ModSounds.SLINGSHOT_CHARGE_2.get();
            default -> ModSounds.SLINGSHOT_CHARGE_3.get();
        };
    }

    public Predicate<ItemStack> m_6437_() {
        return s -> {
            Item i = s.m_41720_();
            return !(i instanceof DispensibleContainerItem) && !s.m_204117_(ModTags.SLINGSHOT_BLACKLIST) && i instanceof BlockItem || ((IExtendedItem)i).hasPlacementBehavior() || InteractEventOverrideHandler.hasBlockPlacementAssociated(i);
        };
    }

    public int m_6615_() {
        return 10;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand) {
        if (entity.m_21212_() > 0 && entity.m_21211_().m_41720_() == this) {
            model.f_102812_.f_104204_ = MthUtils.wrapRad((float)(0.1f + model.f_102808_.f_104204_));
            model.f_102812_.f_104203_ = MthUtils.wrapRad((float)(-1.5707964f + model.f_102808_.f_104203_));
            return true;
        }
        return false;
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand) {
        if (entity.m_21212_() > 0 && entity.m_21211_().m_41720_() == this) {
            model.f_102811_.f_104204_ = MthUtils.wrapRad((float)(-0.1f + model.f_102808_.f_104204_));
            model.f_102811_.f_104203_ = MthUtils.wrapRad((float)(-1.5707964f + model.f_102808_.f_104203_));
            return true;
        }
        return false;
    }

    public void animateItemFirstPerson(LivingEntity entity, ItemStack stack, InteractionHand hand, PoseStack matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity.m_6117_() && entity.m_21212_() > 0 && entity.m_7655_() == hand) {
            float timeLeft = (float)stack.m_41779_() - ((float)entity.m_21212_() - partialTicks + 1.0f);
            float f12 = this.getPowerForTime(stack, timeLeft);
            if (f12 > 0.1f) {
                float f15 = Mth.m_14031_((float)((timeLeft - 0.1f) * 1.3f));
                float f18 = f12 - 0.1f;
                float f20 = f15 * f18;
                matrixStack.m_252880_(0.0f, f20 * 0.004f, 0.0f);
            }
            matrixStack.m_252880_(0.0f, 0.0f, f12 * 0.04f);
            matrixStack.m_85841_(1.0f, 1.0f, 1.0f + f12 * 0.2f);
        }
    }

    public static void animateCrossbowCharge(ModelPart offHand, ModelPart mainHand, LivingEntity entity, boolean right) {
        offHand.f_104203_ = mainHand.f_104203_;
        float f = CrossbowItem.m_40939_((ItemStack)entity.m_21211_());
        float f1 = Mth.m_14036_((float)entity.m_21252_(), (float)0.0f, (float)f);
        float f2 = f1 / f;
        offHand.f_104204_ = Mth.m_14179_((float)f2, (float)0.4f, (float)0.85f) * (float)(right ? 1 : -1);
        offHand.f_104203_ = Mth.m_14179_((float)f2, (float)offHand.f_104203_, (float)-1.5707964f);
    }
}

