/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.forge;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SafeBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.SackContainerMenu;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.InventoryTooltip;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.quark.content.client.module.ChestSearchingModule;
import vazkii.quark.content.client.tooltip.ShulkerBoxTooltips;

public class QuarkInventoryTooltipComponent
implements ClientTooltipComponent {
    private static final int CORNER = 5;
    private static final int BUFFER = 1;
    private static final int EDGE = 18;
    private final CompoundTag tag;
    private final Item item;
    private final int[] dimensions;
    private final int size;
    private final boolean locked;

    public QuarkInventoryTooltipComponent(InventoryTooltip tooltip) {
        SafeBlockTile safe;
        this.tag = tooltip.tag();
        this.item = tooltip.item();
        this.dimensions = SackContainerMenu.getRatio(tooltip.size());
        this.size = tooltip.size();
        BlockEntity te = ItemsUtil.loadBlockEntityFromItem(this.tag, this.item);
        this.locked = te instanceof SafeBlockTile ? !(safe = (SafeBlockTile)te).canPlayerOpen((Player)Minecraft.m_91087_().f_91074_, false) : false;
    }

    public void m_183452_(Font font, int tooltipX, int tooltipY, GuiGraphics graphics) {
        if (this.locked) {
            return;
        }
        BlockEntity te = ItemsUtil.loadBlockEntityFromItem(this.tag, this.item);
        if (te != null) {
            SafeBlockTile safe;
            if (te instanceof SafeBlockTile && !(safe = (SafeBlockTile)te).canPlayerOpen((Player)Minecraft.m_91087_().f_91074_, false)) {
                return;
            }
            LazyOptional handler = te.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
            handler.ifPresent(capability -> {
                int currentX = tooltipX;
                int texWidth = 10 + 18 * this.dimensions[0];
                int right = currentX + texWidth;
                Minecraft mc = Minecraft.m_91087_();
                Window window = mc.m_91268_();
                if (right > window.m_85445_()) {
                    currentX -= right - window.m_85445_();
                }
                PoseStack pose = graphics.m_280168_();
                pose.m_85836_();
                pose.m_85837_(0.0, 0.0, 700.0);
                int color = -1;
                ShulkerBoxTooltips.ShulkerComponent.renderTooltipBackground((Minecraft)mc, (PoseStack)pose, (int)currentX, (int)tooltipY, (int)this.dimensions[0], (int)this.dimensions[1], (int)color);
                for (int i = 0; i < this.size; ++i) {
                    ItemStack itemstack = capability.getStackInSlot(i);
                    int xp = currentX + 6 + i % this.dimensions[0] * 18;
                    int yp = tooltipY + 6 + i / this.dimensions[0] * 18;
                    if (!itemstack.m_41619_()) {
                        graphics.m_280203_(itemstack, xp, yp);
                        graphics.m_280370_(mc.f_91062_, itemstack, xp, yp);
                    }
                    if (ChestSearchingModule.namesMatch((ItemStack)itemstack)) continue;
                    RenderSystem.disableDepthTest();
                    graphics.m_280509_(xp, yp, xp + 16, yp + 16, -1442840576);
                }
                pose.m_85849_();
            });
        }
    }

    public int m_142103_() {
        return this.locked ? 0 : 10 + 18 * this.dimensions[1] + 1;
    }

    public int m_142069_(Font font) {
        return this.locked ? 0 : 10 + 18 * this.dimensions[0];
    }
}

