/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Skeleton.class})
public abstract class SkeletonMixin
extends AbstractSkeleton
implements IQuiverEntity {
    @Unique
    private ItemStack quiver = ItemStack.f_41583_;
    @Unique
    private float quiverDropChance = 0.6f;
    private static final EntityDataAccessor<Boolean> HAS_QUIVER = SynchedEntityData.m_135353_(Skeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected SkeletonMixin(EntityType<? extends AbstractSkeleton> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    protected void defineSynchedData(CallbackInfo ci) {
        this.m_20088_().m_135372_(HAS_QUIVER, (Object)false);
    }

    @Inject(method={"dropCustomDeathLoot"}, at={@At(value="TAIL")})
    protected void dropCustomDeathLoot(DamageSource damageSource, int looting, boolean hitByPlayer, CallbackInfo ci) {
        if (this.quiver != null && hitByPlayer) {
            ItemStack itemStack = this.quiver;
            if (Math.max(this.f_19796_.m_188501_() - (float)looting * 0.02f, 0.0f) < this.quiverDropChance) {
                this.m_19983_(itemStack);
                this.quiver = ItemStack.f_41583_;
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        if (!this.quiver.m_41619_()) {
            compound.m_128365_("Quiver", (Tag)this.quiver.m_41739_(new CompoundTag()));
            compound.m_128350_("QuiverDropChance", this.quiverDropChance);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        if (compound.m_128441_("Quiver")) {
            this.setQuiver(ItemStack.m_41712_((CompoundTag)compound.m_128469_("Quiver")));
            this.quiverDropChance = compound.m_128457_("QuiverDropChance");
        }
    }

    @Override
    public ItemStack getQuiver() {
        return this.quiver;
    }

    @Override
    public boolean hasQuiver() {
        if (this.m_9236_() != null && this.m_9236_().f_46443_) {
            return (Boolean)this.m_20088_().m_135370_(HAS_QUIVER);
        }
        return IQuiverEntity.super.hasQuiver();
    }

    @Override
    public void setQuiver(ItemStack quiver) {
        this.quiver = quiver;
        this.m_20088_().m_135381_(HAS_QUIVER, (Object)(!quiver.m_41619_() ? 1 : 0));
    }

    public boolean m_7243_(ItemStack stack) {
        if (this.quiver == null && stack.m_41720_() == ModRegistry.QUIVER_ITEM.get()) {
            return true;
        }
        return super.m_7243_(stack);
    }

    public ItemStack m_255207_(ItemStack stack) {
        if (stack.m_41720_() == ModRegistry.QUIVER_ITEM.get()) {
            if (this.quiver != null) {
                this.m_19983_(this.quiver);
            }
            this.setQuiver(stack);
            this.quiverDropChance = 1.0f;
            return stack;
        }
        return super.m_255207_(stack);
    }
}

