/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HourGlassBlock;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimeData;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimesManager;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class HourGlassBlockTile
extends ItemDisplayTile {
    private HourglassTimeData sandData = HourglassTimeData.EMPTY;
    private float progress = 0.0f;
    private float prevProgress = 0.0f;
    private int power = 0;
    private ResourceLocation cachedTexture = null;

    public HourGlassBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.HOURGLASS_TILE.get(), pos, state);
    }

    public void updateTileOnInventoryChanged() {
        this.sandData = HourglassTimesManager.getData(this.getDisplayedItem().m_41720_());
        boolean p = this.getDirection() == Direction.DOWN;
        int l = this.sandData.getLight();
        if (l != (Integer)this.m_58900_().m_61143_((Property)HourGlassBlock.LIGHT_LEVEL) && this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)HourGlassBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(l)), 20);
        }
        this.prevProgress = (float)p;
        this.progress = (float)p;
    }

    public HourglassTimeData getSandData() {
        return this.sandData;
    }

    public float getProgress(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevProgress, (float)this.progress);
    }

    public ResourceLocation getTexture() {
        if (this.cachedTexture == null) {
            this.cachedTexture = this.sandData.computeTexture(this.getDisplayedItem(), this.f_58857_);
        }
        return this.cachedTexture;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, HourGlassBlockTile tile) {
        int p;
        Direction dir = (Direction)pState.m_61143_((Property)HourGlassBlock.FACING);
        if (!tile.sandData.isEmpty()) {
            tile.prevProgress = tile.progress;
            if (dir == Direction.UP && tile.progress != 1.0f) {
                tile.progress = Math.min(tile.progress + tile.sandData.getIncrement(), 1.0f);
            } else if (dir == Direction.DOWN && tile.progress != 0.0f) {
                tile.progress = Math.max(tile.progress - tile.sandData.getIncrement(), 0.0f);
            }
        }
        if (!pLevel.f_46443_ && (p = dir == Direction.DOWN ? (int)((1.0f - tile.progress) * 15.0f) : (int)(tile.progress * 15.0f)) != tile.power) {
            tile.power = p;
            pLevel.m_46717_(pPos, pState.m_60734_());
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.progress = compound.m_128457_("Progress");
        this.prevProgress = compound.m_128457_("PrevProgress");
        this.cachedTexture = null;
        this.sandData = HourglassTimesManager.getData(this.getDisplayedItem().m_41720_());
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("Progress", this.progress);
        tag.m_128350_("PrevProgress", this.prevProgress);
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"block.supplementaries.hourglass");
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.m_7983_() && !HourglassTimesManager.getData(stack.m_41720_()).isEmpty();
    }

    public int[] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        if (direction == Direction.UP) {
            return this.m_7013_(0, stack);
        }
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)HourGlassBlock.FACING);
        return dir == Direction.UP && this.progress == 1.0f || dir == Direction.DOWN && this.progress == 0.0f;
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)HourGlassBlock.FACING);
    }

    public int getPower() {
        return this.power;
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.f_12334_;
    }
}

