/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.PlayerSuggestionBoxWidget;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlintBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.RedMerchantMenu;
import net.mehvahdjukaar.supplementaries.common.items.InstrumentItem;
import net.mehvahdjukaar.supplementaries.common.misc.AntiqueInkHelper;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySongNotesPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySpeakerMessagePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendLoginPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncTradesPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ClientReceivers {
    private static void withPlayerDo(Consumer<Player> action) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            action.accept((Player)player);
        }
    }

    private static void withLevelDo(Consumer<Level> action) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            action.accept((Level)level);
        }
    }

    public static void handlePlaySpeakerMessagePacket(ClientBoundPlaySpeakerMessagePacket message) {
        Component str;
        SpeakerBlockTile.Mode mode = message.mode;
        Component component = str = Minecraft.m_91087_().m_167974_() ? message.filtered : message.message;
        if (mode == SpeakerBlockTile.Mode.NARRATOR && !ClientConfigs.Blocks.SPEAKER_BLOCK_MUTE.get().booleanValue()) {
            Minecraft.m_91087_().m_240477_().f_93313_.say(str.getString(), true);
        } else if (mode == SpeakerBlockTile.Mode.TITLE) {
            Gui gui = Minecraft.m_91087_().f_91065_;
            gui.m_168713_();
            gui.m_93006_();
            gui.m_168714_(str);
        } else {
            ClientReceivers.withPlayerDo(p -> p.m_5661_(str, mode == SpeakerBlockTile.Mode.STATUS_MESSAGE));
        }
    }

    public static void handleSendBombKnockbackPacket(ClientBoundSendKnockbackPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Entity e = l.m_6815_(message.id);
            if (e != null) {
                e.m_20256_(e.m_20184_().m_82520_(message.knockbackX, message.knockbackY, message.knockbackZ));
            }
        });
    }

    public static void handleLoginPacket(ClientBoundSendLoginPacket message) {
        ClientReceivers.withPlayerDo(p -> PlayerSuggestionBoxWidget.setUsernameCache(message.usernameCache));
    }

    public static void handleSpawnBlockParticlePacket(ClientBoundParticlePacket message) {
        ClientReceivers.withLevelDo(l -> {
            switch (message.id) {
                case BUBBLE_BLOW: {
                    ParticleUtil.spawnParticlesOnBlockFaces((Level)l, (BlockPos)BlockPos.m_274446_((Position)message.pos), (ParticleOptions)((ParticleOptions)ModParticles.SUDS_PARTICLE.get()), (UniformInt)UniformInt.m_146622_((int)2, (int)4), (float)0.001f, (float)0.01f, (boolean)true);
                    break;
                }
                case BUBBLE_CLEAN: {
                    ParticleUtil.spawnParticleOnBlockShape((Level)l, (BlockPos)BlockPos.m_274446_((Position)message.pos), (ParticleOptions)((ParticleOptions)ModParticles.SUDS_PARTICLE.get()), (UniformInt)UniformInt.m_146622_((int)2, (int)4), (float)0.01f);
                    break;
                }
                case WAX_ON: {
                    ParticleUtil.spawnParticleOnBlockShape((Level)l, (BlockPos)BlockPos.m_274446_((Position)message.pos), (ParticleOptions)ParticleTypes.f_175828_, (UniformInt)UniformInt.m_146622_((int)3, (int)5), (float)0.01f);
                    break;
                }
                case BUBBLE_CLEAN_ENTITY: {
                    Entity e;
                    if (message.extraData == null || (e = l.m_6815_(message.extraData.intValue())) == null) break;
                    ParticleUtil.spawnParticleOnBoundingBox((AABB)e.m_20191_(), (Level)l, (ParticleOptions)((ParticleOptions)ModParticles.SUDS_PARTICLE.get()), (UniformInt)UniformInt.m_146622_((int)2, (int)4), (float)0.01f);
                    break;
                }
                case DISPENSER_MINECART: {
                    boolean j1 = false;
                    boolean j2 = true;
                    boolean k2 = false;
                    double d18 = message.pos.f_82479_ + (double)j1 * 0.6;
                    double d24 = message.pos.f_82480_ + (double)j2 * 0.6;
                    double d28 = message.pos.f_82481_ + (double)k2 * 0.6;
                    for (int i3 = 0; i3 < 10; ++i3) {
                        double d4 = l.f_46441_.m_188500_() * 0.2 + 0.01;
                        double d6 = d18 + (double)j1 * 0.01 + (l.f_46441_.m_188500_() - 0.5) * (double)k2 * 0.5;
                        double d8 = d24 + (double)j2 * 0.01 + (l.f_46441_.m_188500_() - 0.5) * (double)j2 * 0.5;
                        double d30 = d28 + (double)k2 * 0.01 + (l.f_46441_.m_188500_() - 0.5) * (double)j1 * 0.5;
                        double d9 = (double)j1 * d4 + l.f_46441_.m_188583_() * 0.01;
                        double d10 = (double)j2 * d4 + l.f_46441_.m_188583_() * 0.01;
                        double d11 = (double)k2 * d4 + l.f_46441_.m_188583_() * 0.01;
                        l.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d6, d8, d30, d9, d10, d11);
                    }
                    break;
                }
                case FLINT_BLOCK_IGNITE: {
                    if (message.extraData == null || message.pos == null) break;
                    boolean isIronMoving = message.extraData == 1;
                    BlockPos pos = BlockPos.m_274446_((Position)message.pos);
                    for (Direction ironDir : Direction.values()) {
                        BlockPos facingPos = pos.m_121945_(ironDir);
                        BlockState facingState = l.m_8055_(facingPos);
                        if (!(isIronMoving ? facingState.m_60713_(ModRegistry.FLINT_BLOCK.get()) : FlintBlock.canBlockCreateSpark(facingState, l, facingPos, ironDir.m_122424_()))) continue;
                        for (int i = 0; i < 6; ++i) {
                            ParticleUtil.spawnParticleOnFace((Level)l, (BlockPos)facingPos, (Direction)ironDir.m_122424_(), (ParticleOptions)ParticleTypes.f_123797_, (float)-0.5f, (float)0.5f, (boolean)false);
                        }
                    }
                    break;
                }
            }
        });
    }

    public static void handleSyncAntiqueInkPacket(ClientBoundSyncAntiqueInk message) {
        ClientReceivers.withLevelDo(l -> {
            BlockEntity tile = l.m_7702_(message.pos);
            if (tile != null) {
                AntiqueInkHelper.setAntiqueInk(tile, message.ink);
            }
        });
    }

    public static void handlePlaySongNotesPacket(ClientBoundPlaySongNotesPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Player p;
            Item patt7604$temp;
            Entity e = l.m_6815_(message.entityID);
            if (e instanceof Player && (patt7604$temp = (p = (Player)e).m_21211_().m_41720_()) instanceof InstrumentItem) {
                InstrumentItem instrumentItem = (InstrumentItem)patt7604$temp;
                IntListIterator intListIterator = message.notes.iterator();
                while (intListIterator.hasNext()) {
                    int note = (Integer)intListIterator.next();
                    if (note <= 0) continue;
                    l.m_6263_((Player)Minecraft.m_91087_().f_91074_, p.m_20185_(), p.m_20186_(), p.m_20189_(), instrumentItem.getSound(), SoundSource.PLAYERS, instrumentItem.getVolume(), instrumentItem.getPitch(note));
                    instrumentItem.spawnNoteParticle((Level)l, (LivingEntity)p, note);
                }
            }
        });
    }

    public static void handleSyncTradesPacket(ClientBoundSyncTradesPacket message) {
        ClientReceivers.withPlayerDo(p -> {
            AbstractContainerMenu container = p.f_36096_;
            if (message.containerId == container.f_38840_ && container instanceof RedMerchantMenu) {
                RedMerchantMenu containerMenu = (RedMerchantMenu)container;
                containerMenu.setOffers(new MerchantOffers(message.offers.m_45388_()));
                containerMenu.setXp(message.villagerXp);
                containerMenu.setMerchantLevel(message.villagerLevel);
                containerMenu.setShowProgressBar(message.showProgress);
                containerMenu.setCanRestock(message.canRestock);
            }
        });
    }
}

