/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.cosmetics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.valhelsia.valhelsia_core.client.cosmetics.ActiveCosmeticsStorage;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticKey;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticType;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsRegistry;
import net.valhelsia.valhelsia_core.client.cosmetics.source.CosmeticsSource;

public final class CosmeticsManager {
    private static final CosmeticsManager INSTANCE = new CosmeticsManager();
    private final List<UUID> loadedPlayers = new ArrayList<UUID>();
    private final ListMultimap<UUID, CosmeticKey> cosmetics = MultimapBuilder.hashKeys().arrayListValues().build();
    private final Map<UUID, ActiveCosmeticsStorage> activeCosmetics = new HashMap<UUID, ActiveCosmeticsStorage>();
    private final Map<CosmeticKey, CosmeticType> cachedTypes = new HashMap<CosmeticKey, CosmeticType>();

    private CosmeticsManager() {
    }

    public static CosmeticsManager getInstance() {
        return INSTANCE;
    }

    public void loadCosmeticsFor(UUID uuid) {
        this.loadCosmeticsFor(uuid, DataAvailableCallback.EMPTY);
    }

    public void loadCosmeticsFor(UUID uuid, DataAvailableCallback callback) {
        if (this.loadedPlayers.contains(uuid)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            for (CosmeticsSource source : CosmeticsRegistry.getSources()) {
                for (CosmeticKey key : source.loadCosmeticsFor(uuid)) {
                    if (this.getType(key).isEmpty()) continue;
                    this.addCosmeticToPlayer(uuid, key);
                }
            }
        }, Util.m_183991_()).whenComplete((unused, throwable) -> {
            callback.onDataAvailable();
            this.loadedPlayers.add(uuid);
        });
    }

    private void addCosmeticToPlayer(UUID uuid, CosmeticKey key) {
        if (this.cosmetics.get((Object)uuid).stream().noneMatch(key1 -> key1.equals(key))) {
            this.cosmetics.put((Object)uuid, (Object)key);
        }
    }

    public List<CosmeticKey> getCosmetics(UUID uuid) {
        return this.cosmetics.get((Object)uuid);
    }

    public List<CosmeticKey> getCosmetics(UUID uuid, CosmeticsCategory category) {
        return this.getCosmetics(uuid).stream().filter(key -> this.getTypeOrThrow((CosmeticKey)key).category() == category).toList();
    }

    public List<UUID> getLoadedPlayers() {
        return this.loadedPlayers;
    }

    public ActiveCosmeticsStorage getActiveCosmetics(UUID uuid, boolean write) {
        if (write && !this.activeCosmetics.containsKey(uuid)) {
            this.activeCosmetics.put(uuid, new ActiveCosmeticsStorage());
        }
        return this.activeCosmetics.getOrDefault(uuid, ActiveCosmeticsStorage.EMPTY);
    }

    public Optional<CosmeticKey> getActiveCosmetic(UUID uuid, CosmeticsCategory category) {
        return this.getActiveCosmetics(uuid, false).get(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ResourceLocation> getTextures(CosmeticKey key) {
        CosmeticsSource source = key.source();
        CosmeticsManager cosmeticsManager = this;
        synchronized (cosmeticsManager) {
            if (!source.texturesLoaded(key)) {
                source.loadTexturesInternal(key);
                return ImmutableMap.of();
            }
            return source.getTextures(key);
        }
    }

    @Nullable
    public ResourceLocation getMainTexture(CosmeticKey key) {
        return this.getTextures(key).getOrDefault(key.name(), null);
    }

    public Optional<CosmeticType> getType(CosmeticKey key) {
        if (this.cachedTypes.containsKey(key)) {
            return Optional.of(this.cachedTypes.get(key));
        }
        Optional<CosmeticType> optional = key.source().getTypes().stream().filter(type -> type.belongsToType().apply(key.name())).findFirst();
        optional.ifPresent(type -> this.cachedTypes.put(key, (CosmeticType)type));
        return optional;
    }

    public CosmeticType getTypeOrThrow(CosmeticKey key) {
        return this.getType(key).orElseThrow(() -> new IllegalArgumentException("Source doesn't contain a type for the cosmetic: " + key.name()));
    }

    @FunctionalInterface
    public static interface DataAvailableCallback {
        public static final DataAvailableCallback EMPTY = () -> {};

        public void onDataAvailable();
    }
}

