/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.valhelsia.valhelsia_core.common.block.entity.MenuCreationContext;
import net.valhelsia.valhelsia_core.common.util.ItemStackListGetter;
import org.apache.commons.lang3.function.ToBooleanBiFunction;
import org.jetbrains.annotations.NotNull;

public abstract class ValhelsiaContainerBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    public static final int DEFAULT_MAX_STACK_SIZE = 64;
    private final ItemStackHandler itemStackHandler;
    private LockCode lockKey = LockCode.f_19102_;
    private Component name;

    public ValhelsiaContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize) {
        this(type, pos, state, inventorySize, (ToBooleanBiFunction<Integer, ItemStack>)((ToBooleanBiFunction)(integer, stack) -> true));
    }

    public ValhelsiaContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize, final ToBooleanBiFunction<Integer, ItemStack> isItemValid) {
        super(type, pos, state);
        this.itemStackHandler = new ItemStackHandler(inventorySize){

            protected void onContentsChanged(int slot) {
                ValhelsiaContainerBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return isItemValid.applyAsBoolean((Object)slot, (Object)stack);
            }
        };
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.lockKey = LockCode.m_19111_((CompoundTag)tag);
        if (tag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        this.lockKey.m_19109_(tag);
        if (this.name != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    @Nonnull
    public Component m_7755_() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    @Nonnull
    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    protected abstract Component getDefaultName();

    public boolean canOpen(Player player) {
        return ValhelsiaContainerBlockEntity.canUnlock(player, this.lockKey, this.m_5446_());
    }

    public static boolean canUnlock(Player player, LockCode code, Component displayName) {
        if (!player.m_5833_() && !code.m_19107_(player.m_21205_())) {
            player.m_5661_((Component)Component.m_237110_((String)"container.isLocked", (Object[])new Object[]{displayName}), true);
            player.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @Nonnull Inventory inventory, @Nonnull Player player) {
        return this.canOpen(player) ? this.createMenu(containerId, MenuCreationContext.of((IItemHandler)new InvWrapper((Container)inventory), this.f_58857_, this.f_58858_, player)) : null;
    }

    protected abstract AbstractContainerMenu createMenu(int var1, @Nonnull MenuCreationContext var2);

    public int getMaxStackSize() {
        return 64;
    }

    public ItemStack getStack(int slot) {
        return this.itemStackHandler.getStackInSlot(slot);
    }

    public NonNullList<ItemStack> getStacks() {
        ItemStackHandler itemStackHandler = this.itemStackHandler;
        if (itemStackHandler instanceof ItemStackListGetter) {
            ItemStackListGetter itemStackListGetter = (ItemStackListGetter)itemStackHandler;
            return itemStackListGetter.getStacks();
        }
        return NonNullList.m_122779_();
    }

    public void setStack(int slot, ItemStack stack) {
        this.itemStackHandler.setStackInSlot(slot, stack);
        if (stack.m_41613_() > this.getMaxStackSize()) {
            stack.m_41764_(this.getMaxStackSize());
        }
    }

    public void saveInventory(CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemStackHandler.serializeNBT());
    }

    public void loadInventory(CompoundTag tag) {
        this.itemStackHandler.deserializeNBT(tag.m_128469_("Inventory"));
    }
}

