/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.registry;

import com.google.common.collect.ImmutableBiMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.core.ValhelsiaCore;
import net.valhelsia.valhelsia_core.core.config.AbstractConfigValidator;
import net.valhelsia.valhelsia_core.core.registry.helper.RegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.block.BlockRegistryHelper;

public record RegistryManager(String modId, ImmutableBiMap<ResourceKey<? extends Registry<?>>, RegistryHelper<?>> registryHelpers, @Nullable AbstractConfigValidator configValidator) {
    public RegistryManager(String modId, ImmutableBiMap<ResourceKey<? extends Registry<?>>, RegistryHelper<?>> registryHelpers, @Nullable AbstractConfigValidator configValidator) {
        this.modId = modId;
        this.registryHelpers = registryHelpers;
        this.configValidator = configValidator;
        this.registryHelpers.forEach((key, helper) -> helper.setup(this));
    }

    public static Builder builder(String modId) {
        return new Builder(modId);
    }

    public <T> boolean hasHelper(ResourceKey<Registry<T>> registryResourceKey) {
        return this.registryHelpers.containsKey(registryResourceKey);
    }

    public <T, H extends RegistryHelper<T>> H getHelper(ResourceKey<Registry<T>> registryResourceKey) {
        if (!this.hasHelper(registryResourceKey)) {
            throw new NullPointerException("Registry Manager for '" + this.modId() + "' has no Helper for registry: " + registryResourceKey.m_135782_());
        }
        return (H)((RegistryHelper)this.registryHelpers.get(registryResourceKey));
    }

    public BlockRegistryHelper getBlockHelper() {
        return (BlockRegistryHelper)this.getHelper(ForgeRegistries.Keys.BLOCKS);
    }

    public RegistryHelper<Item> getItemHelper() {
        return this.getHelper(ForgeRegistries.Keys.ITEMS);
    }

    public void register(IEventBus eventBus) {
        for (RegistryHelper registryHelper2 : this.registryHelpers.values()) {
            registryHelper2.getRegistryClasses().forEach(Supplier::get);
        }
        this.registryHelpers.values().forEach(registryHelper -> registryHelper.registerDeferredRegister(eventBus));
    }

    public static class Builder {
        private final String modId;
        private final Map<ResourceKey<? extends Registry<?>>, RegistryHelper<?>> registryHelpers = new HashMap();
        private AbstractConfigValidator configValidator = null;

        private Builder(String modId) {
            this.modId = modId;
        }

        public <T> Builder addHelper(ResourceKey<? extends Registry<T>> key, RegistryHelper<T> helper) {
            this.registryHelpers.put(key, helper);
            return this;
        }

        public Builder setConfigValidator(AbstractConfigValidator configValidator) {
            this.configValidator = configValidator;
            return this;
        }

        public RegistryManager create() {
            RegistryManager registryManager = new RegistryManager(this.modId, ImmutableBiMap.copyOf(this.registryHelpers), this.configValidator);
            ValhelsiaCore.REGISTRY_MANAGERS.add(registryManager);
            System.out.println(this.registryHelpers.values());
            return registryManager;
        }
    }
}

