/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.core.registry;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.client.util.ValhelsiaRenderType;
import net.valhelsia.valhelsia_core.core.registry.RegistryClass;
import net.valhelsia.valhelsia_core.core.registry.helper.block.BlockRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.block.RenderType;
import net.valhelsia.valhelsia_furniture.ValhelsiaFurniture;
import net.valhelsia.valhelsia_furniture.common.block.ChairBlock;
import net.valhelsia.valhelsia_furniture.common.block.ClosedCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskDrawerBlock;
import net.valhelsia.valhelsia_furniture.common.block.FabricDeskLampBlock;
import net.valhelsia.valhelsia_furniture.common.block.OpenCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.StoolBlock;
import net.valhelsia.valhelsia_furniture.common.block.TableBlock;
import net.valhelsia.valhelsia_furniture.common.block.UpholsteredChairBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import net.valhelsia.valhelsia_furniture.core.registry.ModTags;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks
implements RegistryClass {
    public static final BlockRegistryHelper HELPER = ValhelsiaFurniture.REGISTRY_MANAGER.getBlockHelper();
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<TableBlock> OAK_TABLE = HELPER.register("oak_table", () -> new TableBlock("oak_table", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<TableBlock> SPRUCE_TABLE = HELPER.register("spruce_table", () -> new TableBlock("spruce_table", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<TableBlock> BIRCH_TABLE = HELPER.register("birch_table", () -> new TableBlock("birch_table", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<TableBlock> JUNGLE_TABLE = HELPER.register("jungle_table", () -> new TableBlock("jungle_table", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<TableBlock> ACACIA_TABLE = HELPER.register("acacia_table", () -> new TableBlock("acacia_table", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<TableBlock> DARK_OAK_TABLE = HELPER.register("dark_oak_table", () -> new TableBlock("dark_oak_table", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<TableBlock> CRIMSON_TABLE = HELPER.register("crimson_table", () -> new TableBlock("crimson_table", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<TableBlock> WARPED_TABLE = HELPER.register("warped_table", () -> new TableBlock("warped_table", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<TableBlock>> OAK_TABLES = ModBlocks.registerTables("oak_table");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<TableBlock>> SPRUCE_TABLES = ModBlocks.registerTables("spruce_table");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<TableBlock>> BIRCH_TABLES = ModBlocks.registerTables("birch_table");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<TableBlock>> JUNGLE_TABLES = ModBlocks.registerTables("jungle_table");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<TableBlock>> ACACIA_TABLES = ModBlocks.registerTables("acacia_table");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<TableBlock>> DARK_OAK_TABLES = ModBlocks.registerTables("dark_oak_table");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<TableBlock>> CRIMSON_TABLES = ModBlocks.registerTables("crimson_table");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<TableBlock>> WARPED_TABLES = ModBlocks.registerTables("warped_table");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> OAK_CHAIR = HELPER.register("oak_chair", () -> new ChairBlock("oak", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> SPRUCE_CHAIR = HELPER.register("spruce_chair", () -> new ChairBlock("spruce", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> BIRCH_CHAIR = HELPER.register("birch_chair", () -> new ChairBlock("birch", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> JUNGLE_CHAIR = HELPER.register("jungle_chair", () -> new ChairBlock("jungle", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> ACACIA_CHAIR = HELPER.register("acacia_chair", () -> new ChairBlock("acacia", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> DARK_OAK_CHAIR = HELPER.register("dark_oak_chair", () -> new ChairBlock("dark_oak", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> CRIMSON_CHAIR = HELPER.register("crimson_chair", () -> new ChairBlock("crimson", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> WARPED_CHAIR = HELPER.register("warped_chair", () -> new ChairBlock("warped", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> HAY_OAK_CHAIR = HELPER.register("hay_oak_chair", () -> new ChairBlock("oak", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> HAY_SPRUCE_CHAIR = HELPER.register("hay_spruce_chair", () -> new ChairBlock("spruce", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> HAY_BIRCH_CHAIR = HELPER.register("hay_birch_chair", () -> new ChairBlock("birch", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> HAY_JUNGLE_CHAIR = HELPER.register("hay_jungle_chair", () -> new ChairBlock("jungle", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> HAY_ACACIA_CHAIR = HELPER.register("hay_acacia_chair", () -> new ChairBlock("acacia", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> HAY_DARK_OAK_CHAIR = HELPER.register("hay_dark_oak_chair", () -> new ChairBlock("dark_oak", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> HAY_CRIMSON_CHAIR = HELPER.register("hay_crimson_chair", () -> new ChairBlock("crimson", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final RegistryObject<ChairBlock> HAY_WARPED_CHAIR = HELPER.register("hay_warped_chair", () -> new ChairBlock("warped", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<ChairBlock>> WOOL_OAK_CHAIRS = ModBlocks.registerWoolChairs("oak_chair");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<ChairBlock>> WOOL_SPRUCE_CHAIRS = ModBlocks.registerWoolChairs("spruce_chair");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<ChairBlock>> WOOL_BIRCH_CHAIRS = ModBlocks.registerWoolChairs("birch_chair");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<ChairBlock>> WOOL_JUNGLE_CHAIRS = ModBlocks.registerWoolChairs("jungle_chair");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<ChairBlock>> WOOL_ACACIA_CHAIRS = ModBlocks.registerWoolChairs("acacia_chair");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<ChairBlock>> WOOL_DARK_OAK_CHAIRS = ModBlocks.registerWoolChairs("dark_oak_chair");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<ChairBlock>> WOOL_CRIMSON_CHAIRS = ModBlocks.registerWoolChairs("crimson_chair");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<ChairBlock>> WOOL_WARPED_CHAIRS = ModBlocks.registerWoolChairs("warped_chair");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<UpholsteredChairBlock>> WOOL_UPHOLSTERED_OAK_CHAIRS = ModBlocks.registerUpholsteredWoolChairs("oak");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<UpholsteredChairBlock>> WOOL_UPHOLSTERED_SPRUCE_CHAIRS = ModBlocks.registerUpholsteredWoolChairs("spruce");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<UpholsteredChairBlock>> WOOL_UPHOLSTERED_BIRCH_CHAIRS = ModBlocks.registerUpholsteredWoolChairs("birch");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<UpholsteredChairBlock>> WOOL_UPHOLSTERED_JUNGLE_CHAIRS = ModBlocks.registerUpholsteredWoolChairs("jungle");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<UpholsteredChairBlock>> WOOL_UPHOLSTERED_ACACIA_CHAIRS = ModBlocks.registerUpholsteredWoolChairs("acacia");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<UpholsteredChairBlock>> WOOL_UPHOLSTERED_DARK_OAK_CHAIRS = ModBlocks.registerUpholsteredWoolChairs("dark_oak");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<UpholsteredChairBlock>> WOOL_UPHOLSTERED_CRIMSON_CHAIRS = ModBlocks.registerUpholsteredWoolChairs("crimson");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<UpholsteredChairBlock>> WOOL_UPHOLSTERED_WARPED_CHAIRS = ModBlocks.registerUpholsteredWoolChairs("warped");
    public static final RegistryObject<StoolBlock> OAK_STOOL = HELPER.register("oak_stool", () -> new StoolBlock("oak", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<StoolBlock> SPRUCE_STOOL = HELPER.register("spruce_stool", () -> new StoolBlock("spruce", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<StoolBlock> BIRCH_STOOL = HELPER.register("birch_stool", () -> new StoolBlock("birch", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<StoolBlock> JUNGLE_STOOL = HELPER.register("jungle_stool", () -> new StoolBlock("jungle", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<StoolBlock> ACACIA_STOOL = HELPER.register("acacia_stool", () -> new StoolBlock("acacia", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<StoolBlock> DARK_OAK_STOOL = HELPER.register("dark_oak_stool", () -> new StoolBlock("dark_oak", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<StoolBlock> CRIMSON_STOOL = HELPER.register("crimson_stool", () -> new StoolBlock("crimson", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<StoolBlock> WARPED_STOOL = HELPER.register("warped_stool", () -> new StoolBlock("warped", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<StoolBlock>> WOOL_UPHOLSTERED_OAK_STOOLS = ModBlocks.registerUpholsteredStools("oak");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<StoolBlock>> WOOL_UPHOLSTERED_SPRUCE_STOOLS = ModBlocks.registerUpholsteredStools("spruce");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<StoolBlock>> WOOL_UPHOLSTERED_BIRCH_STOOLS = ModBlocks.registerUpholsteredStools("birch");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<StoolBlock>> WOOL_UPHOLSTERED_JUNGLE_STOOLS = ModBlocks.registerUpholsteredStools("jungle");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<StoolBlock>> WOOL_UPHOLSTERED_ACACIA_STOOLS = ModBlocks.registerUpholsteredStools("acacia");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<StoolBlock>> WOOL_UPHOLSTERED_DARK_OAK_STOOLS = ModBlocks.registerUpholsteredStools("dark_oak");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<StoolBlock>> WOOL_UPHOLSTERED_CRIMSON_STOOLS = ModBlocks.registerUpholsteredStools("crimson");
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final List<RegistryObject<StoolBlock>> WOOL_UPHOLSTERED_WARPED_STOOLS = ModBlocks.registerUpholsteredStools("warped");
    public static final RegistryObject<DeskBlock> OAK_DESK = HELPER.register("oak_desk", () -> new DeskBlock(ModTags.Blocks.OAK_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskBlock> SPRUCE_DESK = HELPER.register("spruce_desk", () -> new DeskBlock(ModTags.Blocks.SPRUCE_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskBlock> BIRCH_DESK = HELPER.register("birch_desk", () -> new DeskBlock(ModTags.Blocks.BIRCH_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskBlock> JUNGLE_DESK = HELPER.register("jungle_desk", () -> new DeskBlock(ModTags.Blocks.JUNGLE_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskBlock> ACACIA_DESK = HELPER.register("acacia_desk", () -> new DeskBlock(ModTags.Blocks.ACACIA_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskBlock> DARK_OAK_DESK = HELPER.register("dark_oak_desk", () -> new DeskBlock(ModTags.Blocks.DARK_OAK_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskBlock> CRIMSON_DESK = HELPER.register("crimson_desk", () -> new DeskBlock(ModTags.Blocks.CRIMSON_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskBlock> WARPED_DESK = HELPER.register("warped_desk", () -> new DeskBlock(ModTags.Blocks.WARPED_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskDrawerBlock> OAK_DESK_DRAWER = HELPER.register("oak_desk_drawer", () -> new DeskDrawerBlock(ModTags.Blocks.OAK_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskDrawerBlock> SPRUCE_DESK_DRAWER = HELPER.register("spruce_desk_drawer", () -> new DeskDrawerBlock(ModTags.Blocks.SPRUCE_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskDrawerBlock> BIRCH_DESK_DRAWER = HELPER.register("birch_desk_drawer", () -> new DeskDrawerBlock(ModTags.Blocks.BIRCH_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskDrawerBlock> JUNGLE_DESK_DRAWER = HELPER.register("jungle_desk_drawer", () -> new DeskDrawerBlock(ModTags.Blocks.JUNGLE_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskDrawerBlock> ACACIA_DESK_DRAWER = HELPER.register("acacia_desk_drawer", () -> new DeskDrawerBlock(ModTags.Blocks.ACACIA_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskDrawerBlock> DARK_OAK_DESK_DRAWER = HELPER.register("dark_oak_desk_drawer", () -> new DeskDrawerBlock(ModTags.Blocks.DARK_OAK_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskDrawerBlock> CRIMSON_DESK_DRAWER = HELPER.register("crimson_desk_drawer", () -> new DeskDrawerBlock(ModTags.Blocks.CRIMSON_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<DeskDrawerBlock> WARPED_DESK_DRAWER = HELPER.register("warped_desk_drawer", () -> new DeskDrawerBlock(ModTags.Blocks.WARPED_DESKS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    @RenderType(value=ValhelsiaRenderType.CUTOUT)
    public static final Map<DyeColor, RegistryObject<FabricDeskLampBlock>> FABRIC_DESK_LAMPS = ModBlocks.registerColorVariants("fabric_desk_lamp", () -> new FabricDeskLampBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)ModBlockStateProperties.SWITCHED_ON) != false ? 14 : 0)));
    public static final Map<DyeColor, Pair<RegistryObject<ClosedCurtainBlock>, RegistryObject<OpenCurtainBlock>>> CURTAINS = ModBlocks.registerCurtains("curtain");

    public static List<RegistryObject<TableBlock>> registerTables(String name) {
        ArrayList<RegistryObject<TableBlock>> list = new ArrayList<RegistryObject<TableBlock>>();
        for (DyeColor color : DyeColor.values()) {
            list.add((RegistryObject<TableBlock>)HELPER.register(color.m_41065_() + "_" + name, () -> new TableBlock(name, color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_))));
        }
        return list;
    }

    public static List<RegistryObject<ChairBlock>> registerWoolChairs(String name) {
        ArrayList<RegistryObject<ChairBlock>> list = new ArrayList<RegistryObject<ChairBlock>>();
        for (DyeColor color : DyeColor.values()) {
            list.add((RegistryObject<ChairBlock>)HELPER.register(color.m_41065_() + "_" + name, () -> new ChairBlock(name.substring(0, name.length() - 6), color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_))));
        }
        return list;
    }

    public static List<RegistryObject<UpholsteredChairBlock>> registerUpholsteredWoolChairs(String name) {
        ArrayList<RegistryObject<UpholsteredChairBlock>> list = new ArrayList<RegistryObject<UpholsteredChairBlock>>();
        for (DyeColor color : DyeColor.values()) {
            list.add((RegistryObject<UpholsteredChairBlock>)HELPER.register(color.m_41065_() + "_upholstered_" + name + "_chair", () -> new UpholsteredChairBlock(name, color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_))));
        }
        return list;
    }

    public static List<RegistryObject<StoolBlock>> registerUpholsteredStools(String name) {
        ArrayList<RegistryObject<StoolBlock>> list = new ArrayList<RegistryObject<StoolBlock>>();
        for (DyeColor color : DyeColor.values()) {
            list.add((RegistryObject<StoolBlock>)HELPER.register(color.m_41065_() + "_upholstered_" + name + "_stool", () -> new StoolBlock(name, color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_))));
        }
        return list;
    }

    public static <T extends Block> Map<DyeColor, RegistryObject<T>> registerColorVariants(String name, Supplier<T> block) {
        HashMap<DyeColor, RegistryObject<T>> map = new HashMap<DyeColor, RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            map.put(color, HELPER.register(color.m_41065_() + "_" + name, block));
        }
        return map;
    }

    public static Map<DyeColor, Pair<RegistryObject<ClosedCurtainBlock>, RegistryObject<OpenCurtainBlock>>> registerCurtains(String name) {
        HashMap<DyeColor, Pair<RegistryObject<ClosedCurtainBlock>, RegistryObject<OpenCurtainBlock>>> map = new HashMap<DyeColor, Pair<RegistryObject<ClosedCurtainBlock>, RegistryObject<OpenCurtainBlock>>>();
        for (DyeColor color : DyeColor.values()) {
            map.put(color, (Pair<RegistryObject<ClosedCurtainBlock>, RegistryObject<OpenCurtainBlock>>)Pair.of((Object)HELPER.register(color.m_41065_() + "_" + name, () -> new ClosedCurtainBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_60955_())), (Object)HELPER.registerNoItem("open_" + color.m_41065_() + "_" + name, () -> new OpenCurtainBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_60955_().lootFrom((Supplier)CURTAINS.get(color).getFirst())))));
        }
        return map;
    }
}

