/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.data.recipes;

import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.core.data.DataProviderInfo;
import net.valhelsia.valhelsia_core.data.recipes.ValhelsiaRecipeProvider;
import net.valhelsia.valhelsia_furniture.common.block.ChairBlock;
import net.valhelsia.valhelsia_furniture.common.block.ClosedCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskDrawerBlock;
import net.valhelsia.valhelsia_furniture.common.block.FabricDeskLampBlock;
import net.valhelsia.valhelsia_furniture.common.block.StoolBlock;
import net.valhelsia.valhelsia_furniture.common.block.TableBlock;
import net.valhelsia.valhelsia_furniture.common.block.UpholsteredChairBlock;
import net.valhelsia.valhelsia_furniture.core.registry.ModBlocks;

public class ModRecipeProvider
extends ValhelsiaRecipeProvider {
    public ModRecipeProvider(DataProviderInfo info) {
        super(info);
    }

    protected void registerRecipes() {
        this.table(ModBlocks.OAK_TABLE, (ItemLike)Blocks.f_50705_, ModBlocks.OAK_TABLES);
        this.table(ModBlocks.SPRUCE_TABLE, (ItemLike)Blocks.f_50741_, ModBlocks.SPRUCE_TABLES);
        this.table(ModBlocks.BIRCH_TABLE, (ItemLike)Blocks.f_50742_, ModBlocks.BIRCH_TABLES);
        this.table(ModBlocks.JUNGLE_TABLE, (ItemLike)Blocks.f_50743_, ModBlocks.JUNGLE_TABLES);
        this.table(ModBlocks.ACACIA_TABLE, (ItemLike)Blocks.f_50744_, ModBlocks.ACACIA_TABLES);
        this.table(ModBlocks.DARK_OAK_TABLE, (ItemLike)Blocks.f_50745_, ModBlocks.DARK_OAK_TABLES);
        this.table(ModBlocks.CRIMSON_TABLE, (ItemLike)Blocks.f_50655_, ModBlocks.CRIMSON_TABLES);
        this.table(ModBlocks.WARPED_TABLE, (ItemLike)Blocks.f_50656_, ModBlocks.WARPED_TABLES);
        this.desk(ModBlocks.OAK_DESK, ModBlocks.OAK_DESK_DRAWER, (ItemLike)Blocks.f_50705_, (ItemLike)Blocks.f_50398_);
        this.desk(ModBlocks.SPRUCE_DESK, ModBlocks.SPRUCE_DESK_DRAWER, (ItemLike)Blocks.f_50741_, (ItemLike)Blocks.f_50399_);
        this.desk(ModBlocks.BIRCH_DESK, ModBlocks.BIRCH_DESK_DRAWER, (ItemLike)Blocks.f_50742_, (ItemLike)Blocks.f_50400_);
        this.desk(ModBlocks.JUNGLE_DESK, ModBlocks.JUNGLE_DESK_DRAWER, (ItemLike)Blocks.f_50743_, (ItemLike)Blocks.f_50401_);
        this.desk(ModBlocks.ACACIA_DESK, ModBlocks.ACACIA_DESK_DRAWER, (ItemLike)Blocks.f_50744_, (ItemLike)Blocks.f_50402_);
        this.desk(ModBlocks.DARK_OAK_DESK, ModBlocks.DARK_OAK_DESK_DRAWER, (ItemLike)Blocks.f_50745_, (ItemLike)Blocks.f_50403_);
        this.desk(ModBlocks.CRIMSON_DESK, ModBlocks.CRIMSON_DESK_DRAWER, (ItemLike)Blocks.f_50655_, (ItemLike)Blocks.f_50657_);
        this.desk(ModBlocks.WARPED_DESK, ModBlocks.WARPED_DESK_DRAWER, (ItemLike)Blocks.f_50656_, (ItemLike)Blocks.f_50658_);
        this.chair(ModBlocks.OAK_CHAIR, ModBlocks.HAY_OAK_CHAIR, (ItemLike)Blocks.f_50705_, ModBlocks.WOOL_OAK_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_OAK_CHAIRS);
        this.chair(ModBlocks.SPRUCE_CHAIR, ModBlocks.HAY_SPRUCE_CHAIR, (ItemLike)Blocks.f_50741_, ModBlocks.WOOL_SPRUCE_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_SPRUCE_CHAIRS);
        this.chair(ModBlocks.BIRCH_CHAIR, ModBlocks.HAY_BIRCH_CHAIR, (ItemLike)Blocks.f_50742_, ModBlocks.WOOL_BIRCH_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_BIRCH_CHAIRS);
        this.chair(ModBlocks.JUNGLE_CHAIR, ModBlocks.HAY_JUNGLE_CHAIR, (ItemLike)Blocks.f_50743_, ModBlocks.WOOL_JUNGLE_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_JUNGLE_CHAIRS);
        this.chair(ModBlocks.ACACIA_CHAIR, ModBlocks.HAY_ACACIA_CHAIR, (ItemLike)Blocks.f_50744_, ModBlocks.WOOL_ACACIA_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_ACACIA_CHAIRS);
        this.chair(ModBlocks.DARK_OAK_CHAIR, ModBlocks.HAY_DARK_OAK_CHAIR, (ItemLike)Blocks.f_50745_, ModBlocks.WOOL_DARK_OAK_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_DARK_OAK_CHAIRS);
        this.chair(ModBlocks.CRIMSON_CHAIR, ModBlocks.HAY_CRIMSON_CHAIR, (ItemLike)Blocks.f_50655_, ModBlocks.WOOL_CRIMSON_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_CRIMSON_CHAIRS);
        this.chair(ModBlocks.WARPED_CHAIR, ModBlocks.HAY_WARPED_CHAIR, (ItemLike)Blocks.f_50656_, ModBlocks.WOOL_WARPED_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_WARPED_CHAIRS);
        ModBlocks.CURTAINS.forEach((color, pair) -> this.curtain((RegistryObject<ClosedCurtainBlock>)((RegistryObject)pair.getFirst()), (DyeColor)color));
        this.stool(ModBlocks.OAK_STOOL, (ItemLike)Blocks.f_50398_, ModBlocks.WOOL_UPHOLSTERED_OAK_STOOLS);
        this.stool(ModBlocks.SPRUCE_STOOL, (ItemLike)Blocks.f_50399_, ModBlocks.WOOL_UPHOLSTERED_SPRUCE_STOOLS);
        this.stool(ModBlocks.BIRCH_STOOL, (ItemLike)Blocks.f_50400_, ModBlocks.WOOL_UPHOLSTERED_BIRCH_STOOLS);
        this.stool(ModBlocks.JUNGLE_STOOL, (ItemLike)Blocks.f_50401_, ModBlocks.WOOL_UPHOLSTERED_JUNGLE_STOOLS);
        this.stool(ModBlocks.ACACIA_STOOL, (ItemLike)Blocks.f_50402_, ModBlocks.WOOL_UPHOLSTERED_ACACIA_STOOLS);
        this.stool(ModBlocks.DARK_OAK_STOOL, (ItemLike)Blocks.f_50403_, ModBlocks.WOOL_UPHOLSTERED_DARK_OAK_STOOLS);
        this.stool(ModBlocks.CRIMSON_STOOL, (ItemLike)Blocks.f_50657_, ModBlocks.WOOL_UPHOLSTERED_CRIMSON_STOOLS);
        this.stool(ModBlocks.WARPED_STOOL, (ItemLike)Blocks.f_50658_, ModBlocks.WOOL_UPHOLSTERED_WARPED_STOOLS);
        ModBlocks.FABRIC_DESK_LAMPS.forEach((color, registryObject) -> this.fabricDeskLamp((RegistryObject<FabricDeskLampBlock>)registryObject, (DyeColor)color));
    }

    private void table(RegistryObject<TableBlock> table, ItemLike material, List<RegistryObject<TableBlock>> coloredTables) {
        this.table(table, material);
        coloredTables.forEach(registryObject -> this.coloredTable((RegistryObject<TableBlock>)registryObject, table));
    }

    private void table(RegistryObject<TableBlock> block, ItemLike material) {
        this.shaped((ItemLike)block.get(), builder -> builder.group("valhelsia_furniture:table").pattern("###").pattern("X X").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).unlockedBy((ValhelsiaRecipeProvider)this, material));
    }

    private void coloredTable(RegistryObject<TableBlock> block, RegistryObject<TableBlock> table) {
        Block carpet = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(Objects.requireNonNull(((TableBlock)((Object)block.get())).getColor()).m_41065_() + "_carpet"));
        if (carpet != null) {
            this.shaped((ItemLike)block.get(), builder -> builder.group("valhelsia_furniture:colored_" + ((TableBlock)((Object)((Object)block.get()))).getBaseName()).pattern("#").pattern("X").define(Character.valueOf('#'), (ItemLike)carpet).define(Character.valueOf('X'), (ItemLike)table.get()).unlockedBy((ValhelsiaRecipeProvider)this, (ItemLike)table.get()).unlockedBy((ValhelsiaRecipeProvider)this, (ItemLike)carpet));
        }
    }

    private void desk(RegistryObject<DeskBlock> desk, RegistryObject<DeskDrawerBlock> deskDrawer, ItemLike material, ItemLike materialSlab) {
        this.desk(desk, material);
        this.deskDrawer(deskDrawer, material, materialSlab);
    }

    private void desk(RegistryObject<DeskBlock> block, ItemLike material) {
        this.shaped((ItemLike)block.get(), builder -> builder.group("valhelsia_furniture:desk").pattern("###").pattern("# #").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).unlockedBy((ValhelsiaRecipeProvider)this, material));
    }

    private void deskDrawer(RegistryObject<DeskDrawerBlock> block, ItemLike material, ItemLike materialSlab) {
        this.shaped((ItemLike)block.get(), builder -> builder.group("valhelsia_furniture:desk_drawer").pattern("###").pattern("#S#").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('S'), materialSlab).unlockedBy((ValhelsiaRecipeProvider)this, material).unlockedBy((ValhelsiaRecipeProvider)this, materialSlab));
    }

    private void chair(RegistryObject<ChairBlock> chair, RegistryObject<ChairBlock> hayChair, ItemLike material, List<RegistryObject<ChairBlock>> coloredChairs, List<RegistryObject<UpholsteredChairBlock>> upholsteredChairs) {
        this.chair(chair, material);
        this.hayChair(hayChair, material);
        coloredChairs.forEach(registryObject -> this.coloredChair((RegistryObject<ChairBlock>)registryObject, material));
        upholsteredChairs.forEach(registryObject -> this.upholsteredChair((RegistryObject<UpholsteredChairBlock>)registryObject, material));
    }

    private void chair(RegistryObject<ChairBlock> block, ItemLike material) {
        this.shaped((ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:chair").pattern("X  ").pattern("###").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).unlockedBy((ValhelsiaRecipeProvider)this, material));
    }

    private void coloredChair(RegistryObject<ChairBlock> block, ItemLike material) {
        Block wool = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(Objects.requireNonNull(((ChairBlock)block.get()).getColor()).m_41065_() + "_wool"));
        if (wool != null) {
            this.shaped((ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:colored_" + ((ChairBlock)block.get()).getBaseName()).pattern("X  ").pattern("#WW").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), (ItemLike)wool).unlockedBy((ValhelsiaRecipeProvider)this, material).unlockedBy((ValhelsiaRecipeProvider)this, (ItemLike)wool));
        }
    }

    private void hayChair(RegistryObject<ChairBlock> block, ItemLike material) {
        this.shaped((ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:hayChair").pattern("X  ").pattern("#HH").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('H'), (ItemLike)Blocks.f_50335_).unlockedBy((ValhelsiaRecipeProvider)this, material).unlockedBy((ValhelsiaRecipeProvider)this, (ItemLike)Blocks.f_50335_));
    }

    private void upholsteredChair(RegistryObject<UpholsteredChairBlock> block, ItemLike material) {
        Block wool = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(Objects.requireNonNull(((UpholsteredChairBlock)block.get()).getColor()).m_41065_() + "_wool"));
        if (wool != null) {
            this.shaped((ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:upholstered_" + ((UpholsteredChairBlock)block.get()).getBaseName()).pattern("W  ").pattern("#WW").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), (ItemLike)wool).unlockedBy((ValhelsiaRecipeProvider)this, material).unlockedBy((ValhelsiaRecipeProvider)this, (ItemLike)wool));
        }
    }

    private void curtain(RegistryObject<ClosedCurtainBlock> block, DyeColor color) {
        Block wool = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(color.m_41065_() + "_wool"));
        if (wool != null) {
            this.shaped((ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:curtain").pattern("XX").pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)wool).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)wool)));
        }
    }

    private void stool(RegistryObject<StoolBlock> stool, ItemLike material, List<RegistryObject<StoolBlock>> upholsteredStools) {
        this.stool(stool, material);
        upholsteredStools.forEach(registryObject -> this.upholsteredStool((RegistryObject<StoolBlock>)registryObject, material));
    }

    private void stool(RegistryObject<StoolBlock> block, ItemLike material) {
        this.shaped((ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:stool").pattern("###").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).unlockedBy((ValhelsiaRecipeProvider)this, material));
    }

    private void upholsteredStool(RegistryObject<StoolBlock> block, ItemLike material) {
        Block wool = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(Objects.requireNonNull(((StoolBlock)block.get()).getColor()).m_41065_() + "_wool"));
        if (wool != null) {
            this.shaped((ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:upholstered_" + ((StoolBlock)block.get()).getBaseName()).pattern("#W#").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), (ItemLike)wool).unlockedBy((ValhelsiaRecipeProvider)this, material).unlockedBy((ValhelsiaRecipeProvider)this, (ItemLike)wool));
        }
    }

    private void fabricDeskLamp(RegistryObject<FabricDeskLampBlock> block, DyeColor color) {
        Block wool = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(color.m_41065_() + "_wool"));
        if (wool != null) {
            this.shaped((ItemLike)block.get(), builder -> builder.group("valhelsia_furniture:fabric_desk_lamp").pattern("#").pattern("G").pattern("X").define(Character.valueOf('#'), (ItemLike)wool).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('G'), (ItemLike)Items.f_42525_).unlockedBy((ValhelsiaRecipeProvider)this, (ItemLike)wool).unlockedBy((ValhelsiaRecipeProvider)this, (ItemLike)Items.f_42525_));
        }
    }
}

