/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RequestEditWaystoneMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<RequestEditWaystoneMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)"request_edit_waystone"));
    private final BlockPos pos;

    public RequestEditWaystoneMessage(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(FriendlyByteBuf buf, RequestEditWaystoneMessage message) {
        buf.writeBlockPos(message.pos);
    }

    public static RequestEditWaystoneMessage decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        return new RequestEditWaystoneMessage(pos);
    }

    public static void handle(ServerPlayer player, RequestEditWaystoneMessage message) {
        BlockPos pos = message.pos;
        if (player.distanceToSqr((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f)) > 64.0) {
            return;
        }
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
            waystoneBlockEntity.getSettingsMenuProvider().ifPresent(menuProvider -> Balm.getNetworking().openGui((Player)player, menuProvider));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

